/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.ConfigurationRegistry;
import org.stagemonitor.configuration.converter.BooleanValueConverter;
import org.stagemonitor.configuration.converter.ClassInstanceValueConverter;
import org.stagemonitor.configuration.converter.DoubleValueConverter;
import org.stagemonitor.configuration.converter.EnumValueConverter;
import org.stagemonitor.configuration.converter.IntegerValueConverter;
import org.stagemonitor.configuration.converter.JsonValueConverter;
import org.stagemonitor.configuration.converter.ListValueConverter;
import org.stagemonitor.configuration.converter.LongValueConverter;
import org.stagemonitor.configuration.converter.MapValueConverter;
import org.stagemonitor.configuration.converter.OptionalValueConverter;
import org.stagemonitor.configuration.converter.RegexValueConverter;
import org.stagemonitor.configuration.converter.SetValueConverter;
import org.stagemonitor.configuration.converter.StringValueConverter;
import org.stagemonitor.configuration.converter.UrlValueConverter;
import org.stagemonitor.configuration.converter.ValueConverter;
import org.stagemonitor.configuration.source.ConfigurationSource;

public class ConfigurationOption<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean dynamic;
    private final boolean sensitive;
    private final String key;
    private final List<String> aliasKeys;
    private final List<String> allKeys;
    private final String label;
    private final String description;
    private final T defaultValue;
    private final List<String> tags;
    private final List<Validator<T>> validators;
    private final List<ChangeListener<T>> changeListeners;
    private final boolean required;
    private final String defaultValueAsString;
    private final String configurationCategory;
    @JsonIgnore
    private final ValueConverter<T> valueConverter;
    private final Class<? super T> valueType;
    private final Map<String, String> validOptions;
    private String valueAsString;
    private T value;
    private List<ConfigurationSource> configurationSources;
    private String nameOfCurrentConfigurationSource;
    private String errorMessage;
    private ConfigurationRegistry configuration;
    private String usedKey;

    public static <T> ConfigurationOptionBuilder<T> builder(ValueConverter<T> valueConverter, Class<? super T> valueType) {
        return new ConfigurationOptionBuilder(valueConverter, valueType);
    }

    public static ConfigurationOptionBuilder<String> stringOption() {
        return new ConfigurationOptionBuilder<String>(StringValueConverter.INSTANCE, String.class);
    }

    public static <T> ConfigurationOptionBuilder<T> jsonOption(TypeReference<T> typeReference, Class<? super T> clazz) {
        return new ConfigurationOptionBuilder(new JsonValueConverter<T>(typeReference), clazz);
    }

    public static ConfigurationOptionBuilder<Boolean> booleanOption() {
        return new ConfigurationOptionBuilder<Boolean>(BooleanValueConverter.INSTANCE, Boolean.class);
    }

    public static ConfigurationOptionBuilder<Integer> integerOption() {
        return new ConfigurationOptionBuilder<Integer>(IntegerValueConverter.INSTANCE, Integer.class);
    }

    public static ConfigurationOptionBuilder<Long> longOption() {
        return new ConfigurationOptionBuilder<Long>(LongValueConverter.INSTANCE, Long.class);
    }

    public static ConfigurationOptionBuilder<Double> doubleOption() {
        return new ConfigurationOptionBuilder<Double>(DoubleValueConverter.INSTANCE, Double.class);
    }

    public static ConfigurationOptionBuilder<Collection<String>> stringsOption() {
        return new ConfigurationOptionBuilder(SetValueConverter.STRINGS_VALUE_CONVERTER, Collection.class).defaultValue(Collections.emptySet());
    }

    public static ConfigurationOptionBuilder<Collection<String>> lowerStringsOption() {
        return new ConfigurationOptionBuilder(SetValueConverter.LOWER_STRINGS_VALUE_CONVERTER, Collection.class).defaultValue(Collections.emptySet());
    }

    public static ConfigurationOptionBuilder<Collection<Integer>> integersOption() {
        return ConfigurationOption.builder(SetValueConverter.INTEGERS, Collection.class);
    }

    public static ConfigurationOptionBuilder<Collection<Pattern>> regexListOption() {
        return new ConfigurationOptionBuilder(new SetValueConverter<Pattern>(RegexValueConverter.INSTANCE), Collection.class).defaultValue(Collections.emptySet());
    }

    public static ConfigurationOptionBuilder<Map<Pattern, String>> regexMapOption() {
        return new ConfigurationOptionBuilder(MapValueConverter.REGEX_MAP_VALUE_CONVERTER, Map.class).defaultValue(Collections.emptyMap());
    }

    public static <K, V> ConfigurationOptionBuilder<Map<K, V>> mapOption(ValueConverter<K> keyConverter, ValueConverter<V> valueConverter) {
        return new ConfigurationOptionBuilder(new MapValueConverter<K, V>(keyConverter, valueConverter), Map.class).defaultValue(Collections.emptyMap());
    }

    public static <T extends Enum<T>> ConfigurationOptionBuilder<T> enumOption(Class<T> clazz) {
        ConfigurationOptionBuilder<Enum> optionBuilder = new ConfigurationOptionBuilder<Enum>(new EnumValueConverter<T>(clazz), clazz);
        for (Enum enumConstant : (Enum[])clazz.getEnumConstants()) {
            optionBuilder.addValidOption(enumConstant);
        }
        optionBuilder.sealValidOptions();
        return optionBuilder;
    }

    public static <T> ConfigurationOptionBuilder<T> serviceLoaderStrategyOption(Class<T> serviceLoaderInterface) {
        ConfigurationOptionBuilder<T> optionBuilder = new ConfigurationOptionBuilder<T>(ClassInstanceValueConverter.of(serviceLoaderInterface), serviceLoaderInterface);
        for (T impl : ServiceLoader.load(serviceLoaderInterface, ConfigurationOption.class.getClassLoader())) {
            optionBuilder.addValidOption(impl);
        }
        optionBuilder.sealValidOptions();
        return optionBuilder;
    }

    public static ConfigurationOptionBuilder<URL> urlOption() {
        return new ConfigurationOptionBuilder<URL>(UrlValueConverter.INSTANCE, URL.class);
    }

    public static ConfigurationOptionBuilder<List<URL>> urlsOption() {
        return new ConfigurationOptionBuilder(new ListValueConverter<URL>(UrlValueConverter.INSTANCE), List.class).defaultValue(Collections.emptyList());
    }

    private ConfigurationOption(boolean dynamic, boolean sensitive, String key, String label, String description, T defaultValue, String configurationCategory, ValueConverter<T> valueConverter, Class<? super T> valueType, List<String> tags, boolean required, List<ChangeListener<T>> changeListeners, List<Validator<T>> validators, List<String> aliasKeys, Map<String, String> validOptions) {
        this.dynamic = dynamic;
        this.key = key;
        this.aliasKeys = aliasKeys;
        this.label = label;
        this.description = description;
        this.defaultValue = defaultValue;
        this.tags = tags;
        validators = new ArrayList<Validator<T>>(validators);
        if (validOptions != null) {
            this.validOptions = Collections.unmodifiableMap(new LinkedHashMap<String, String>(validOptions));
            validators.add(new ValidOptionValidator<T>(validOptions.keySet(), valueConverter));
        } else {
            this.validOptions = null;
        }
        this.validators = Collections.unmodifiableList(new ArrayList<Validator<T>>(validators));
        this.defaultValueAsString = valueConverter.toString(defaultValue);
        this.configurationCategory = configurationCategory;
        this.valueConverter = valueConverter;
        this.valueType = valueType;
        this.sensitive = sensitive;
        this.required = required;
        this.changeListeners = new ArrayList<ChangeListener<T>>(changeListeners);
        this.setToDefault();
        ArrayList<String> tempAllKeys = new ArrayList<String>(aliasKeys.size() + 1);
        tempAllKeys.add(key);
        tempAllKeys.addAll(aliasKeys);
        this.allKeys = Collections.unmodifiableList(tempAllKeys);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getAliasKeys() {
        return Collections.unmodifiableList(this.aliasKeys);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public String getValueAsSafeString() {
        return this.valueConverter.toSafeString(this.value);
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    @JsonIgnore
    public T getValue() {
        return this.value;
    }

    @JsonIgnore
    public T get() {
        return this.getValue();
    }

    void setConfigurationSources(List<ConfigurationSource> configurationSources) {
        this.configurationSources = configurationSources;
        this.loadValue();
    }

    void setConfiguration(ConfigurationRegistry configuration) {
        this.configuration = configuration;
    }

    public String getNameOfCurrentConfigurationSource() {
        return this.nameOfCurrentConfigurationSource;
    }

    public String getConfigurationCategory() {
        return this.configurationCategory;
    }

    public List<String> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public String getValueType() {
        return this.valueType.getSimpleName();
    }

    public ValueConverter<T> getValueConverter() {
        return this.valueConverter;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Collection<String> getValidOptions() {
        if (this.validOptions == null) {
            return null;
        }
        return this.validOptions.keySet();
    }

    public Map<String, String> getValidOptionsLabelMap() {
        return this.validOptions;
    }

    synchronized void reload(boolean reloadNonDynamicValues) {
        if (this.dynamic || reloadNonDynamicValues) {
            this.loadValue();
        }
    }

    private void loadValue() {
        boolean success = false;
        for (String key : this.allKeys) {
            ConfigValueInfo configValueInfo = this.loadValueFromSources(key);
            success = this.trySetValue(configValueInfo);
            if (!success) continue;
            this.usedKey = key;
            break;
        }
        if (!success) {
            this.setToDefault();
        }
    }

    private ConfigValueInfo loadValueFromSources(String key) {
        for (ConfigurationSource configurationSource : this.configurationSources) {
            String newValueAsString = configurationSource.getValue(key);
            if (newValueAsString == null) continue;
            return new ConfigValueInfo(newValueAsString, configurationSource.getName());
        }
        return new ConfigValueInfo();
    }

    private boolean trySetValue(ConfigValueInfo configValueInfo) {
        String newConfigurationSourceName = configValueInfo.getNewConfigurationSourceName();
        String newValueAsString = configValueInfo.getNewValueAsString();
        if (newValueAsString == null) {
            return false;
        }
        newValueAsString = newValueAsString.trim();
        T oldValue = this.getValue();
        if (this.hasChanges(newValueAsString)) {
            try {
                T newValue = this.valueConverter.convert(newValueAsString);
                this.setValue(newValue, newValueAsString, newConfigurationSourceName);
                this.errorMessage = null;
                if (this.isInitialized()) {
                    for (ChangeListener<T> changeListener : this.changeListeners) {
                        try {
                            changeListener.onChange(this, oldValue, this.getValue());
                        }
                        catch (RuntimeException e) {
                            this.logger.warn(e.getMessage() + " (this exception is ignored)", e);
                        }
                    }
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                this.errorMessage = "Error in " + newConfigurationSourceName + ": " + e.getMessage();
                this.logger.warn(this.errorMessage + " Default value '" + this.defaultValueAsString + "' for '" + this.key + "' will be applied.");
                return false;
            }
        }
        return true;
    }

    private void setToDefault() {
        String msg = "Missing required value for configuration option " + this.key;
        if (this.isInitialized() && this.required && this.defaultValue == null) {
            this.handleMissingRequiredValue(msg);
        }
        this.setValue(this.defaultValue, this.defaultValueAsString, "Default Value");
    }

    private boolean isInitialized() {
        return this.configuration != null;
    }

    private void handleMissingRequiredValue(String msg) {
        if (this.configuration.isFailOnMissingRequiredValues()) {
            throw new IllegalStateException(msg);
        }
        this.logger.warn(msg);
    }

    private boolean hasChanges(String property) {
        return !property.equals(this.valueAsString);
    }

    public void assertValid(String valueAsString) throws IllegalArgumentException {
        T value = this.valueConverter.convert(valueAsString);
        for (Validator<T> validator : this.validators) {
            validator.assertValid(value);
        }
    }

    public void update(T newValue, String configurationSourceName) throws IOException {
        String newValueAsString = this.valueConverter.toString(newValue);
        this.configuration.save(this.key, newValueAsString, configurationSourceName);
    }

    private void setValue(T value, String valueAsString, String nameOfCurrentConfigurationSource) {
        for (Validator<T> validator : this.validators) {
            validator.assertValid(value);
        }
        this.value = value;
        this.valueAsString = valueAsString;
        this.nameOfCurrentConfigurationSource = nameOfCurrentConfigurationSource;
    }

    public boolean isDefault() {
        return this.valueAsString != null && this.valueAsString.equals(this.defaultValueAsString) || this.valueAsString == null && this.defaultValueAsString == null;
    }

    public void addChangeListener(ChangeListener<T> changeListener) {
        this.changeListeners.add(changeListener);
    }

    public boolean removeChangeListener(ChangeListener<T> changeListener) {
        return this.changeListeners.remove(changeListener);
    }

    public String getUsedKey() {
        return this.usedKey;
    }

    private static class ValidOptionValidator<T>
    implements Validator<T> {
        private final Set<String> validOptions;
        private final ValueConverter<T> valueConverter;

        ValidOptionValidator(Collection<String> validOptions, ValueConverter<T> valueConverter) {
            this.validOptions = new HashSet<String>(validOptions);
            this.valueConverter = valueConverter;
        }

        @Override
        public void assertValid(T value) {
            String valueAsString = this.valueConverter.toString(value);
            if (!this.validOptions.contains(valueAsString)) {
                throw new IllegalArgumentException("Invalid option '" + valueAsString + "' expecting one of " + this.validOptions);
            }
        }
    }

    private static class ConfigValueInfo {
        private String newValueAsString;
        private String newConfigurationSourceName;

        private ConfigValueInfo() {
        }

        private ConfigValueInfo(String newValueAsString, String newConfigurationSourceName) {
            this.newValueAsString = newValueAsString;
            this.newConfigurationSourceName = newConfigurationSourceName;
        }

        private String getNewValueAsString() {
            return this.newValueAsString;
        }

        private String getNewConfigurationSourceName() {
            return this.newConfigurationSourceName;
        }
    }

    public static class ConfigurationOptionBuilder<T> {
        private boolean dynamic = false;
        private boolean sensitive = false;
        private String key;
        private String label;
        private String description;
        private T defaultValue;
        private String configurationCategory;
        private ValueConverter<T> valueConverter;
        private Class<? super T> valueType;
        private String[] tags = new String[0];
        private boolean required = false;
        private List<ChangeListener<T>> changeListeners = new ArrayList<ChangeListener<T>>();
        private List<Validator<T>> validators = new ArrayList<Validator<T>>();
        private String[] aliasKeys = new String[0];
        private Map<String, String> validOptions;
        private boolean validOptionsSealed = false;

        private ConfigurationOptionBuilder(ValueConverter<T> valueConverter, Class<? super T> valueType) {
            this.valueConverter = valueConverter;
            this.valueType = valueType;
        }

        @Deprecated
        public ConfigurationOption<T> build() {
            return new ConfigurationOption(this.dynamic, this.sensitive, this.key, this.label, this.description, this.defaultValue, this.configurationCategory, this.valueConverter, this.valueType, Arrays.asList(this.tags), this.required, this.changeListeners, this.validators, Arrays.asList(this.aliasKeys), this.validOptions);
        }

        public ConfigurationOption<T> buildRequired() {
            this.required = true;
            return this.build();
        }

        public ConfigurationOption<T> buildWithDefault(T defaultValue) {
            if (defaultValue == null) {
                throw new IllegalArgumentException("Default value must not be null");
            }
            this.required = true;
            this.defaultValue = defaultValue;
            return this.build();
        }

        public ConfigurationOption<Optional<T>> buildOptional() {
            this.required = false;
            ArrayList<ChangeListener.OptionalChangeListenerAdapter<T>> optionalChangeListeners = new ArrayList<ChangeListener.OptionalChangeListenerAdapter<T>>(this.changeListeners.size());
            for (ChangeListener<T> changeListener : this.changeListeners) {
                optionalChangeListeners.add(new ChangeListener.OptionalChangeListenerAdapter<T>(changeListener));
            }
            ArrayList<Validator.OptionalValidatorAdapter<T>> optionalValidators = new ArrayList<Validator.OptionalValidatorAdapter<T>>(this.validators.size());
            for (Validator<T> validator : this.validators) {
                optionalValidators.add(new Validator.OptionalValidatorAdapter<T>(validator));
            }
            return new ConfigurationOption<Optional<T>>(this.dynamic, this.sensitive, this.key, this.label, this.description, Optional.ofNullable(this.defaultValue), this.configurationCategory, new OptionalValueConverter<T>(this.valueConverter), Optional.class, Arrays.asList(this.tags), this.required, optionalChangeListeners, optionalValidators, Arrays.asList(this.aliasKeys), this.validOptions);
        }

        public ConfigurationOptionBuilder<T> dynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public ConfigurationOptionBuilder<T> key(String key) {
            this.key = key;
            return this;
        }

        public ConfigurationOptionBuilder<T> aliasKeys(String ... aliasKeys) {
            this.aliasKeys = aliasKeys;
            return this;
        }

        public ConfigurationOptionBuilder<T> label(String label) {
            this.label = label;
            return this;
        }

        public ConfigurationOptionBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public ConfigurationOptionBuilder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ConfigurationOptionBuilder<T> configurationCategory(String configurationCategory) {
            this.configurationCategory = configurationCategory;
            return this;
        }

        public ConfigurationOptionBuilder<T> tags(String ... tags) {
            this.tags = tags;
            return this;
        }

        public ConfigurationOptionBuilder<T> sensitive() {
            this.sensitive = true;
            return this;
        }

        @Deprecated
        public ConfigurationOptionBuilder<T> required() {
            this.required = true;
            return this;
        }

        public ConfigurationOptionBuilder<T> addChangeListener(ChangeListener<T> changeListener) {
            this.changeListeners.add(changeListener);
            return this;
        }

        public ConfigurationOptionBuilder<T> addValidator(Validator<T> validator) {
            this.validators.add(validator);
            return this;
        }

        public ConfigurationOptionBuilder<T> validOptions(List<T> options) {
            for (T option : options) {
                this.addValidOption(option);
            }
            return this;
        }

        public ConfigurationOptionBuilder<T> addValidOptions(T ... options) {
            for (T option : options) {
                this.addValidOption(option);
            }
            return this;
        }

        public ConfigurationOptionBuilder<T> addValidOption(T option) {
            if (option instanceof Collection) {
                throw new UnsupportedOperationException("Adding valid options to a collection option is not supported. If you need this feature please raise an issue describing your use case.");
            }
            String validOptionAsString = this.valueConverter.toString(option);
            this.addValidOptionAsString(validOptionAsString, this.getLabel(option, validOptionAsString));
            return this;
        }

        private String getLabel(Object option, String defaultLabel) {
            if (this.overridesToString(option)) {
                return option.toString();
            }
            return defaultLabel;
        }

        private boolean overridesToString(Object o) {
            try {
                return o.getClass().getDeclaredMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        private T getSingleValue(Object o) {
            return (T)Collections.singletonList(o);
        }

        private ConfigurationOptionBuilder<T> addValidOptionAsString(String validOptionAsString, String label) {
            if (this.validOptionsSealed) {
                throw new IllegalStateException("Options are sealed, you can't add any new ones");
            }
            if (this.validOptions == null) {
                this.validOptions = new LinkedHashMap<String, String>();
            }
            this.validOptions.put(validOptionAsString, label);
            return this;
        }

        public ConfigurationOptionBuilder<T> sealValidOptions() {
            this.validOptionsSealed = true;
            if (this.validOptions != null) {
                this.validOptions = Collections.unmodifiableMap(this.validOptions);
            }
            return this;
        }
    }

    public static interface Validator<T> {
        public void assertValid(T var1);

        public static class OptionalValidatorAdapter<T>
        implements Validator<Optional<T>> {
            private final Validator<T> validator;

            public OptionalValidatorAdapter(Validator<T> validator) {
                this.validator = validator;
            }

            @Override
            public void assertValid(Optional<T> value) {
                this.validator.assertValid(value.orElse(null));
            }
        }
    }

    public static interface ChangeListener<T> {
        public void onChange(ConfigurationOption<?> var1, T var2, T var3);

        public static class OptionalChangeListenerAdapter<T>
        implements ChangeListener<Optional<T>> {
            private final ChangeListener<T> changeListener;

            public OptionalChangeListenerAdapter(ChangeListener<T> changeListener) {
                this.changeListener = changeListener;
            }

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Optional<T> oldValue, Optional<T> newValue) {
                this.changeListener.onChange(configurationOption, oldValue.orElse(null), newValue.orElse(null));
            }
        }
    }
}

