/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Marker;

public class EcsEncoder
extends EncoderBase<ILoggingEvent> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private String serviceNodeName;
    private String eventDataset;
    private boolean includeMarkers = false;
    private ThrowableProxyConverter throwableProxyConverter;
    private boolean includeOrigin;
    private final List<AdditionalField> additionalFields = new ArrayList<AdditionalField>();
    private OutputStream os;

    public byte[] headerBytes() {
        return null;
    }

    public void start() {
        super.start();
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.throwableProxyConverter.start();
        this.eventDataset = EcsJsonSerializer.computeEventDataset(this.eventDataset, this.serviceName);
    }

    public void init(OutputStream os) {
        this.os = os;
    }

    public void doEncode(Object event) throws IOException {
        this.os.write(this.encode((ILoggingEvent)event));
        this.os.flush();
    }

    public void close() throws IOException {
    }

    public byte[] encode(ILoggingEvent event) {
        IThrowableProxy throwableProxy;
        StackTraceElement[] callerData;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart(builder, event.getTimeStamp());
        EcsJsonSerializer.serializeLogLevel(builder, event.getLevel().toString());
        EcsJsonSerializer.serializeFormattedMessage(builder, event.getFormattedMessage());
        EcsJsonSerializer.serializeEcsVersion(builder);
        this.serializeMarkers(event, builder);
        EcsJsonSerializer.serializeServiceName(builder, this.serviceName);
        EcsJsonSerializer.serializeServiceNodeName(builder, this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset(builder, this.eventDataset);
        EcsJsonSerializer.serializeThreadName(builder, event.getThreadName());
        EcsJsonSerializer.serializeLoggerName(builder, event.getLoggerName());
        EcsJsonSerializer.serializeAdditionalFields(builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC(builder, event.getMDCPropertyMap());
        if (this.includeOrigin && (callerData = event.getCallerData()) != null && callerData.length > 0) {
            EcsJsonSerializer.serializeOrigin(builder, callerData[0]);
        }
        if ((throwableProxy = event.getThrowableProxy()) instanceof ThrowableProxy) {
            EcsJsonSerializer.serializeException(builder, ((ThrowableProxy)throwableProxy).getThrowable(), this.stackTraceAsArray);
        } else if (throwableProxy != null) {
            EcsJsonSerializer.serializeException(builder, throwableProxy.getClassName(), throwableProxy.getMessage(), this.throwableProxyConverter.convert(event), this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd(builder);
        return builder.toString().getBytes(UTF_8);
    }

    private void serializeMarkers(ILoggingEvent event, StringBuilder builder) {
        Marker marker = event.getMarker();
        if (this.includeMarkers && marker != null) {
            EcsJsonSerializer.serializeTagStart(builder);
            this.serializeMarker(builder, marker);
            EcsJsonSerializer.serializeTagEnd(builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        if (marker != null) {
            EcsJsonSerializer.serializeSingleTag(builder, marker.getName());
            Iterator<Marker> it = marker.iterator();
            while (it.hasNext()) {
                this.serializeMarker(builder, it.next());
            }
        }
    }

    public byte[] footerBytes() {
        return null;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setIncludeMarkers(boolean includeMarkers) {
        this.includeMarkers = includeMarkers;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void addAdditionalField(AdditionalField pair) {
        this.additionalFields.add(pair);
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }
}

