/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v4.webclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.vertx.AbstractVertxWebClientHelper;
import co.elastic.apm.agent.vertx.AbstractVertxWebHelper;
import co.elastic.apm.agent.vertx.v4.Vertx4Instrumentation;
import io.vertx.core.Context;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class HttpContextInstrumentation
extends Vertx4Instrumentation {
    protected static final String WEB_CLIENT_PARENT_SPAN_KEY = AbstractVertxWebClientHelper.class.getName() + ".parent";

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("vertx", "vertx-webclient", "http-client", "experimental");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.ext.web.client.impl.HttpContext");
    }

    public static class HttpContextFailInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("fail").and(ElementMatchers.takesArgument(0, Throwable.class));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.webclient.HttpContextInstrumentation$HttpContextFailInstrumentation$HttpContextFailAdvice";
        }

        public static class HttpContextFailAdvice
        extends AdviceBase {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void fail(@Advice.This HttpContext<?> httpContext, @Advice.Argument(value=0) Throwable thrown) {
                AbstractSpan parent = null;
                Object parentFromContext = httpContext.get(WEB_CLIENT_PARENT_SPAN_KEY);
                if (parentFromContext != null) {
                    parent = (AbstractSpan)parentFromContext;
                    httpContext.set(WEB_CLIENT_PARENT_SPAN_KEY, null);
                    parent.decrementReferences();
                }
                webClientHelper.failSpan(httpContext, thrown, parent);
            }
        }
    }

    public static class HttpContextDispatchResponseInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("dispatchResponse").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.ext.web.client.HttpResponse")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.webclient.HttpContextInstrumentation$HttpContextDispatchResponseInstrumentation$HttpContextDispatchResponseAdvice";
        }

        public static class HttpContextDispatchResponseAdvice
        extends AdviceBase {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void receiveResponse(@Advice.This HttpContext<?> httpContext, @Advice.Argument(value=0) HttpResponse<?> response) {
                webClientHelper.endSpan(httpContext, response);
            }
        }
    }

    public static class HttpContextSendRequestInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("sendRequest").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.http.HttpClientRequest")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.webclient.HttpContextInstrumentation$HttpContextSendRequestInstrumentation$HttpContextSendRequestAdvice";
        }

        public static class HttpContextSendRequestAdvice
        extends AdviceBase {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void sendRequest(@Advice.This HttpContext<?> httpContext, @Advice.Argument(value=0) HttpClientRequest request, @Advice.FieldValue(value="context") Context vertxContext) {
                Object parentSpan = httpContext.get(WEB_CLIENT_PARENT_SPAN_KEY);
                if (parentSpan != null) {
                    httpContext.set(WEB_CLIENT_PARENT_SPAN_KEY, null);
                    ((AbstractSpan)parentSpan).decrementReferences();
                } else {
                    parentSpan = vertxContext.getLocal((Object)AbstractVertxWebHelper.CONTEXT_TRANSACTION_KEY);
                }
                if (parentSpan != null) {
                    AbstractSpan parent = (AbstractSpan)parentSpan;
                    webClientHelper.startSpan(parent, httpContext, request);
                }
            }
        }
    }

    public static class HttpContextPrepareRequestInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("prepareRequest");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.webclient.HttpContextInstrumentation$HttpContextPrepareRequestInstrumentation$HttpContextPrepareRequestAdvice";
        }

        public static class HttpContextPrepareRequestAdvice
        extends AdviceBase {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void prepareRequest(@Advice.This HttpContext<?> httpContext) {
                AbstractSpan<?> activeSpan = TracerAwareInstrumentation.tracer.getActive();
                if (null != activeSpan) {
                    activeSpan.incrementReferences();
                    httpContext.set(WEB_CLIENT_PARENT_SPAN_KEY, activeSpan);
                }
            }
        }
    }

    public static class AdviceBase {
        protected static final AbstractVertxWebClientHelper webClientHelper = new AbstractVertxWebClientHelper(){

            @Override
            protected String getMethod(HttpClientRequest request) {
                return request.getMethod().name();
            }
        };
    }
}

