/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LoggerUtils {
    public static Logger logOnce(Logger logger) {
        return new LogOnceLogger(logger);
    }

    private static class LogOnceLogger
    implements Logger {
        private final Logger delegate;
        private final AtomicBoolean alreadyLogged = new AtomicBoolean(false);

        private LogOnceLogger(Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        private boolean isEnabled(boolean delegateEnabled) {
            if (this.alreadyLogged.get()) {
                return false;
            }
            return delegateEnabled;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isEnabled(this.delegate.isTraceEnabled());
        }

        @Override
        public void trace(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(msg);
            }
        }

        @Override
        public void trace(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(format, arg);
            }
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(format, arg1, arg2);
            }
        }

        @Override
        public void trace(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(format, arguments);
            }
        }

        @Override
        public void trace(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(msg, t);
            }
        }

        @Override
        public boolean isTraceEnabled(Marker marker) {
            return this.isEnabled(this.delegate.isTraceEnabled(marker));
        }

        @Override
        public void trace(Marker marker, String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(marker, msg);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(marker, format, arg);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(marker, format, arg1, arg2);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object ... argArray) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(marker, format, argArray);
            }
        }

        @Override
        public void trace(Marker marker, String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(marker, msg, t);
            }
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isEnabled(this.delegate.isDebugEnabled());
        }

        @Override
        public void debug(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(msg);
            }
        }

        @Override
        public void debug(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(format, arg);
            }
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(format, arg1, arg2);
            }
        }

        @Override
        public void debug(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(format, arguments);
            }
        }

        @Override
        public void debug(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(msg, t);
            }
        }

        @Override
        public boolean isDebugEnabled(Marker marker) {
            return this.isEnabled(this.delegate.isDebugEnabled(marker));
        }

        @Override
        public void debug(Marker marker, String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(marker, msg);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(marker, format, arg);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(marker, format, arg1, arg2);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(marker, format, arguments);
            }
        }

        @Override
        public void debug(Marker marker, String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(marker, msg, t);
            }
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isEnabled(this.delegate.isInfoEnabled());
        }

        @Override
        public void info(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(msg);
            }
        }

        @Override
        public void info(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(format, arg);
            }
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(format, arg1, arg2);
            }
        }

        @Override
        public void info(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(format, arguments);
            }
        }

        @Override
        public void info(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(msg, t);
            }
        }

        @Override
        public boolean isInfoEnabled(Marker marker) {
            return this.isEnabled(this.delegate.isInfoEnabled(marker));
        }

        @Override
        public void info(Marker marker, String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(marker, msg);
            }
        }

        @Override
        public void info(Marker marker, String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(marker, format, arg);
            }
        }

        @Override
        public void info(Marker marker, String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(marker, format, arg1, arg2);
            }
        }

        @Override
        public void info(Marker marker, String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(marker, format, arguments);
            }
        }

        @Override
        public void info(Marker marker, String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(marker, msg, t);
            }
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isEnabled(this.delegate.isWarnEnabled());
        }

        @Override
        public void warn(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(msg);
            }
        }

        @Override
        public void warn(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(format, arg);
            }
        }

        @Override
        public void warn(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(format, arguments);
            }
        }

        @Override
        public void warn(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(format, arg1, arg2);
            }
        }

        @Override
        public void warn(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(msg, t);
            }
        }

        @Override
        public boolean isWarnEnabled(Marker marker) {
            return this.isEnabled(this.delegate.isWarnEnabled(marker));
        }

        @Override
        public void warn(Marker marker, String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(marker, msg);
            }
        }

        @Override
        public void warn(Marker marker, String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(marker, format, arg);
            }
        }

        @Override
        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(marker, format, arg1, arg2);
            }
        }

        @Override
        public void warn(Marker marker, String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(marker, format, arguments);
            }
        }

        @Override
        public void warn(Marker marker, String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(marker, msg, t);
            }
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isEnabled(this.delegate.isErrorEnabled());
        }

        @Override
        public void error(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(msg);
            }
        }

        @Override
        public void error(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(format, arg);
            }
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(format, arg1, arg2);
            }
        }

        @Override
        public void error(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(format, arguments);
            }
        }

        @Override
        public void error(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(msg, t);
            }
        }

        @Override
        public boolean isErrorEnabled(Marker marker) {
            return this.isEnabled(this.delegate.isErrorEnabled(marker));
        }

        @Override
        public void error(Marker marker, String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(marker, msg);
            }
        }

        @Override
        public void error(Marker marker, String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(marker, format, arg);
            }
        }

        @Override
        public void error(Marker marker, String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(marker, format, arg1, arg2);
            }
        }

        @Override
        public void error(Marker marker, String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(marker, format, arguments);
            }
        }

        @Override
        public void error(Marker marker, String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(marker, msg, t);
            }
        }
    }
}

