/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebmvc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.TransactionNameUtils;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ServletWrappingControllerServiceNameInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.servlet.mvc.ServletWrappingController");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handleRequestInternal");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("spring-mvc");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.FieldValue(value="servletClass") Class<?> servletClass, @Advice.Argument(value=0) HttpServletRequest request) {
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction == null) {
                return;
            }
            TransactionNameUtils.setTransactionNameByServletClass(request.getMethod(), servletClass, transaction.getAndOverrideName(100));
        }
    }
}

