/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.servlet.helper.CommonServletRequestHeaderGetter;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletTransactionCreationHelper<HTTPREQUEST, CONTEXT> {
    private static final Logger logger = LoggerFactory.getLogger(ServletTransactionCreationHelper.class);
    private final Tracer tracer;
    private final WebConfiguration webConfiguration;

    public ServletTransactionCreationHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
    }

    @Nullable
    public Transaction createAndActivateTransaction(HTTPREQUEST request) {
        if (this.tracer.currentTransaction() != null) {
            return null;
        }
        if (this.isExcluded(request)) {
            return null;
        }
        ClassLoader cl = this.getClassloader(this.getServletContext(request));
        Transaction transaction = this.tracer.startChildTransaction(request, this.getRequestHeaderGetter(), cl);
        if (transaction != null) {
            transaction.activate();
        }
        return transaction;
    }

    protected abstract String getServletPath(HTTPREQUEST var1);

    protected abstract String getPathInfo(HTTPREQUEST var1);

    protected abstract String getHeader(HTTPREQUEST var1, String var2);

    protected abstract CONTEXT getServletContext(HTTPREQUEST var1);

    protected abstract ClassLoader getClassLoader(CONTEXT var1);

    protected abstract CommonServletRequestHeaderGetter getRequestHeaderGetter();

    protected abstract String getContextPath(HTTPREQUEST var1);

    protected abstract String getRequestURI(HTTPREQUEST var1);

    boolean isExcluded(HTTPREQUEST request) {
        boolean isExcluded;
        WildcardMatcher excludeAgentMatcher;
        String userAgent = this.getHeader(request, "User-Agent");
        String requestUri = this.getRequestURI(request);
        WildcardMatcher excludeUrlMatcher = WildcardMatcher.anyMatch(this.webConfiguration.getIgnoreUrls(), requestUri);
        if (excludeUrlMatcher != null && logger.isDebugEnabled()) {
            logger.debug("Not tracing this request as the URL {} is ignored by the matcher {}", (Object)requestUri, (Object)excludeUrlMatcher);
        }
        WildcardMatcher wildcardMatcher = excludeAgentMatcher = userAgent != null ? WildcardMatcher.anyMatch(this.webConfiguration.getIgnoreUserAgents(), userAgent) : null;
        if (excludeAgentMatcher != null) {
            logger.debug("Not tracing this request as the User-Agent {} is ignored by the matcher {}", (Object)userAgent, (Object)excludeAgentMatcher);
        }
        boolean bl = isExcluded = excludeUrlMatcher != null || excludeAgentMatcher != null;
        if (!isExcluded && logger.isTraceEnabled()) {
            logger.trace("No matcher found for excluding this request with URL: {}, and User-Agent: {}", (Object)requestUri, (Object)userAgent);
        }
        return isExcluded;
    }

    @Nullable
    public ClassLoader getClassloader(@Nullable CONTEXT servletContext) {
        if (servletContext == null) {
            return null;
        }
        Object classLoader = null;
        try {
            return this.getClassLoader(servletContext);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

