/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.servlet.helper.JakartaAsyncContextAdviceHelper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class JakartaApmAsyncListener
implements AsyncListener,
Recyclable {
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final JakartaAsyncContextAdviceHelper asyncContextAdviceHelperImpl;
    private final ServletTransactionHelper servletTransactionHelper;
    @Nullable
    private volatile Transaction transaction;
    @Nullable
    private volatile Throwable throwable;

    JakartaApmAsyncListener(JakartaAsyncContextAdviceHelper asyncContextAdviceHelperImpl) {
        this.asyncContextAdviceHelperImpl = asyncContextAdviceHelperImpl;
        this.servletTransactionHelper = asyncContextAdviceHelperImpl.getServletTransactionHelper();
    }

    JakartaApmAsyncListener withTransaction(Transaction transaction) {
        this.transaction = transaction;
        return this;
    }

    public void onComplete(AsyncEvent event) {
        this.endTransaction(event);
    }

    public void onTimeout(AsyncEvent event) {
        this.throwable = event.getThrowable();
        if (this.isJBossEap6(event)) {
            this.endTransaction(event);
        }
    }

    public void onError(AsyncEvent event) {
        this.throwable = event.getThrowable();
        if (this.isJBossEap6(event)) {
            this.endTransaction(event);
        }
    }

    private boolean isJBossEap6(AsyncEvent event) {
        ServletContext context = event.getSuppliedRequest().getServletContext();
        return context.getMajorVersion() == 3 && context.getMinorVersion() == 0 && System.getProperty("jboss.home.dir") != null;
    }

    public void onStartAsync(AsyncEvent event) {
        AsyncContext eventAsyncContext = event.getAsyncContext();
        if (eventAsyncContext != null) {
            eventAsyncContext.addListener((AsyncListener)this, event.getSuppliedRequest(), event.getSuppliedResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransaction(AsyncEvent event) {
        if (this.completed.getAndSet(true) || this.transaction == null) {
            return;
        }
        try {
            HttpServletRequest request = (HttpServletRequest)event.getSuppliedRequest();
            request.removeAttribute(ServletTransactionHelper.TRANSACTION_ATTRIBUTE);
            HttpServletResponse response = (HttpServletResponse)event.getSuppliedResponse();
            Response resp = this.transaction.getContext().getResponse();
            if (this.transaction.isSampled() && this.servletTransactionHelper.isCaptureHeaders()) {
                for (String headerName : response.getHeaderNames()) {
                    resp.addHeader(headerName, response.getHeaders(headerName));
                }
            }
            String contentTypeHeader = request.getHeader("Content-Type");
            Map parameterMap = this.transaction.isSampled() && this.servletTransactionHelper.captureParameters(request.getMethod(), contentTypeHeader) ? request.getParameterMap() : null;
            Throwable throwableToSend = event.getThrowable();
            if (throwableToSend == null) {
                throwableToSend = this.throwable;
            }
            this.servletTransactionHelper.onAfter(this.transaction, throwableToSend, response.isCommitted(), response.getStatus(), true, request.getMethod(), parameterMap, request.getServletPath(), request.getPathInfo(), contentTypeHeader, false);
        }
        finally {
            this.asyncContextAdviceHelperImpl.recycle(this);
        }
    }

    @Override
    public void resetState() {
        this.transaction = null;
        this.throwable = null;
        this.completed.set(false);
    }
}

