/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.state.GlobalVariables;
import co.elastic.apm.agent.sdk.weakconcurrent.DetachedThreadLocal;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.servlet.RequestDispatcherSpanType;
import co.elastic.apm.agent.servlet.ServletHelper;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.util.TransactionNameUtils;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ServletApiAdvice {
    private static final String FRAMEWORK_NAME = "Servlet API";
    static final String SPAN_TYPE = "servlet";
    static final String SPAN_SUBTYPE = "request-dispatcher";
    private static final ServletTransactionHelper servletTransactionHelper = new ServletTransactionHelper(GlobalTracer.requireTracerImpl());
    private static final DetachedThreadLocal<Boolean> excluded = GlobalVariables.get(ServletApiAdvice.class, "excluded", WeakConcurrent.buildThreadLocal());
    private static final DetachedThreadLocal<Object> servletPathTL = GlobalVariables.get(ServletApiAdvice.class, "servletPath", WeakConcurrent.buildThreadLocal());
    private static final DetachedThreadLocal<Object> pathInfoTL = GlobalVariables.get(ServletApiAdvice.class, "pathInfo", WeakConcurrent.buildThreadLocal());
    private static final List<String> requestExceptionAttributes = Arrays.asList("javax.servlet.error.exception", "jakarta.servlet.error.exception", "exception", "org.springframework.web.servlet.DispatcherServlet.EXCEPTION", "co.elastic.apm.exception");

    @Nullable
    public static <REQUEST, RESPONSE, HTTPREQUEST, HTTPRESPONSE, CONTEXT> Object onServletEnter(REQUEST servletRequest, ServletHelper<REQUEST, RESPONSE, HTTPREQUEST, HTTPRESPONSE, CONTEXT> helper) {
        AbstractSpan<?> parent;
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (tracer == null) {
            return null;
        }
        AbstractSpan ret = null;
        Transaction transactionAttr = (Transaction)helper.getAttribute(servletRequest, ServletTransactionHelper.TRANSACTION_ATTRIBUTE);
        if (tracer.currentTransaction() == null && transactionAttr != null) {
            return transactionAttr.activateInScope();
        }
        if (!tracer.isRunning() || !helper.isHttpServletRequest(servletRequest)) {
            return null;
        }
        REQUEST httpServletRequest = servletRequest;
        CoreConfiguration coreConfig = tracer.getConfig(CoreConfiguration.class);
        if (helper.isRequestDispatcherType(servletRequest)) {
            Transaction transaction;
            if (Boolean.TRUE == excluded.get()) {
                return null;
            }
            CONTEXT servletContext = helper.getServletContext(servletRequest);
            if (servletContext != null) {
                ClassLoader servletCL = helper.getClassloader(servletContext);
                ServletTransactionHelper.determineServiceName(helper.getServletContextName(servletContext), servletCL, helper.getContextPath(servletContext));
            }
            if ((transaction = helper.createAndActivateTransaction(httpServletRequest)) == null) {
                excluded.set(Boolean.TRUE);
                return null;
            }
            Request req = transaction.getContext().getRequest();
            if (transaction.isSampled() && coreConfig.isCaptureHeaders()) {
                helper.handleCookies(req, httpServletRequest);
                Enumeration<String> headerNames = helper.getRequestHeaderNames(httpServletRequest);
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = headerNames.nextElement();
                        req.addHeader(headerName, helper.getRequestHeaders(httpServletRequest, headerName));
                    }
                }
            }
            transaction.setFrameworkName(FRAMEWORK_NAME);
            servletTransactionHelper.fillRequestContext(transaction, helper.getProtocol(httpServletRequest), helper.getMethod(httpServletRequest), helper.isSecure(httpServletRequest), helper.getScheme(httpServletRequest), helper.getServerName(httpServletRequest), helper.getServerPort(httpServletRequest), helper.getRequestURI(httpServletRequest), helper.getQueryString(httpServletRequest), helper.getRemoteAddr(httpServletRequest), helper.getHeader(httpServletRequest, "Content-Type"));
            ret = transaction;
        } else if (!helper.isAsyncDispatcherType(servletRequest) && coreConfig.isInstrumentationEnabled("servlet-api-dispatch") && (parent = tracer.getActive()) != null) {
            Object servletPath = null;
            Object pathInfo = null;
            RequestDispatcherSpanType spanType = null;
            if (helper.isForwardDispatcherType(servletRequest)) {
                spanType = RequestDispatcherSpanType.FORWARD;
                servletPath = helper.getServletPath(httpServletRequest);
                pathInfo = helper.getPathInfo(httpServletRequest);
            } else if (helper.isIncludeDispatcherType(servletRequest)) {
                spanType = RequestDispatcherSpanType.INCLUDE;
                servletPath = helper.getIncludeServletPathAttribute(httpServletRequest);
                pathInfo = helper.getIncludePathInfoAttribute(httpServletRequest);
            } else if (helper.isErrorDispatcherType(servletRequest)) {
                spanType = RequestDispatcherSpanType.ERROR;
                servletPath = helper.getServletPath(httpServletRequest);
            }
            if (spanType != null && (ServletApiAdvice.areNotEqual(servletPathTL.get(), servletPath) || ServletApiAdvice.areNotEqual(pathInfoTL.get(), pathInfo))) {
                ret = ((Span)parent.createSpan().appendToName(spanType.getNamePrefix())).withAction(spanType.getAction()).withType(SPAN_TYPE).withSubtype(SPAN_SUBTYPE);
                if (servletPath != null) {
                    ret.appendToName(servletPath.toString());
                    servletPathTL.set(servletPath);
                }
                if (pathInfo != null) {
                    ret.appendToName(pathInfo.toString());
                    pathInfoTL.set(pathInfo);
                }
                ret.activate();
            }
        }
        return ret;
    }

    public static <REQUEST, RESPONSE, HTTPREQUEST, HTTPRESPONSE, CONTEXT> void onExitServlet(REQUEST servletRequest, RESPONSE servletResponse, @Nullable Object transactionOrScopeOrSpan, @Nullable Throwable t, Object thiz, ServletHelper<REQUEST, RESPONSE, HTTPREQUEST, HTTPRESPONSE, CONTEXT> helper) {
        Transaction currentTransaction;
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (tracer == null) {
            return;
        }
        Transaction transaction = null;
        Scope scope = null;
        Span span = null;
        if (transactionOrScopeOrSpan instanceof Transaction) {
            transaction = (Transaction)transactionOrScopeOrSpan;
        } else if (transactionOrScopeOrSpan instanceof Scope) {
            scope = (Scope)transactionOrScopeOrSpan;
        } else if (transactionOrScopeOrSpan instanceof Span) {
            span = (Span)transactionOrScopeOrSpan;
        }
        excluded.remove();
        if (scope != null) {
            scope.close();
        }
        if (helper.isInstanceOfHttpServlet(thiz) && helper.isHttpServletRequest(servletRequest) && (currentTransaction = tracer.currentTransaction()) != null) {
            REQUEST httpServletRequest = servletRequest;
            TransactionNameUtils.setTransactionNameByServletClass(helper.getMethod(httpServletRequest), thiz.getClass(), currentTransaction.getAndOverrideName(10));
            Principal userPrincipal = helper.getUserPrincipal(httpServletRequest);
            ServletTransactionHelper.setUsernameIfUnset(userPrincipal != null ? userPrincipal.getName() : null, currentTransaction.getContext());
        }
        if (transaction != null && helper.isHttpServletRequest(servletRequest) && helper.isHttpServletResponse(servletResponse)) {
            REQUEST httpServletRequest = servletRequest;
            if (helper.getHttpAttribute(httpServletRequest, ServletTransactionHelper.ASYNC_ATTRIBUTE) != null) {
                transaction.deactivate();
            } else {
                RESPONSE response = servletResponse;
                if (transaction.isSampled() && tracer.getConfig(CoreConfiguration.class).isCaptureHeaders()) {
                    Response resp = transaction.getContext().getResponse();
                    for (String headerName : helper.getHeaderNames(response)) {
                        resp.addHeader(headerName, helper.getHeaders(response, headerName));
                    }
                }
                String contentTypeHeader = helper.getHeader(httpServletRequest, "Content-Type");
                Map<String, String[]> parameterMap = transaction.isSampled() && servletTransactionHelper.captureParameters(helper.getMethod(httpServletRequest), contentTypeHeader) ? helper.getParameterMap(httpServletRequest) : null;
                Throwable t2 = null;
                boolean overrideStatusCodeOnThrowable = true;
                if (t == null) {
                    int size = requestExceptionAttributes.size();
                    for (int i = 0; i < size; ++i) {
                        String attributeName = requestExceptionAttributes.get(i);
                        Object throwable = helper.getHttpAttribute(httpServletRequest, attributeName);
                        if (!(throwable instanceof Throwable)) continue;
                        t2 = (Throwable)throwable;
                        if (attributeName.equals("javax.servlet.error.exception") || attributeName.equals("jakarta.servlet.error.exception")) break;
                        overrideStatusCodeOnThrowable = false;
                        break;
                    }
                }
                servletTransactionHelper.onAfter(transaction, t == null ? t2 : t, helper.isCommitted(response), helper.getStatus(response), overrideStatusCodeOnThrowable, helper.getMethod(httpServletRequest), parameterMap, helper.getServletPath(httpServletRequest), helper.getPathInfo(httpServletRequest), contentTypeHeader, true);
            }
        }
        if (span != null) {
            servletPathTL.remove();
            pathInfoTL.remove();
            ((Span)((Span)((Span)span.captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
        }
    }

    private static boolean areNotEqual(@Nullable Object first, @Nullable Object second) {
        if (first == null) {
            return second != null;
        }
        return !first.equals(second);
    }
}

