/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.servlet.RequestStreamRecordingInstrumentation;
import co.elastic.apm.agent.servlet.helper.JavaxRecordingServletInputStreamWrapper;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import net.bytebuddy.asm.Advice;

public class JavaxRequestStreamRecordingInstrumentation
extends RequestStreamRecordingInstrumentation {
    @Override
    String typeMatcherClassName() {
        return "javax.servlet.ServletRequest";
    }

    @Override
    String servletInputStreamArgumentClassName() {
        return "javax.servlet.ServletInputStream";
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.servlet.JavaxRequestStreamRecordingInstrumentation$GetInputStreamAdvice";
    }

    @Override
    public String rootClassNameThatClassloaderCanLoad() {
        return "javax.servlet.AsyncContext";
    }

    public static class GetInputStreamAdvice {
        private static final CallDepth callDepth = CallDepth.get(GetInputStreamAdvice.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onReadEnter(@Advice.This Object thiz) {
            callDepth.increment();
        }

        @Nullable
        @Advice.AssignReturned.ToReturned
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static ServletInputStream afterGetInputStream(@Advice.Return @Nullable ServletInputStream inputStream) {
            if (callDepth.isNestedCallAndDecrement() || inputStream == null) {
                return inputStream;
            }
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction != null && transaction.getContext().getRequest().getBodyBuffer() != null) {
                return new JavaxRecordingServletInputStreamWrapper(transaction.getContext().getRequest(), inputStream);
            }
            return inputStream;
        }
    }
}

