/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.scheduled;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerTaskInstrumentation
extends TracerAwareInstrumentation {
    private static final String FRAMEWORK_NAME = "TimerTask";
    public static final Logger logger = LoggerFactory.getLogger(TimerTaskInstrumentation.class);
    private final Collection<String> applicationPackages;

    public TimerTaskInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.none()).and(ElementMatchers.hasSuperClass(ElementMatchers.named("java.util.TimerTask")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("run");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("timer-task");
    }

    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$TimerTaskAdvice";
    }

    public static class TimerTaskAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object setTransactionName(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @Advice.Origin Class<?> clazz) {
            AbstractSpan<?> active = TracerAwareInstrumentation.tracer.getActive();
            if (active == null) {
                Transaction transaction = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader());
                if (transaction != null) {
                    ((Transaction)transaction.withName(signature)).withType("scheduled").activate();
                    transaction.setFrameworkName(TimerTaskInstrumentation.FRAMEWORK_NAME);
                    return transaction;
                }
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object transactionObj, @Advice.Thrown Throwable t) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                ((Transaction)((Transaction)transaction.captureException(t)).deactivate()).end();
            }
        }
    }
}

