/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.HttpUtils;
import co.elastic.apm.agent.util.ExecutorUtils;
import co.elastic.apm.agent.util.Version;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmServerHealthChecker
implements Callable<Version> {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerHealthChecker.class);
    private static final DslJson<Object> dslJson = new DslJson(new DslJson.Settings());
    private final ApmServerClient apmServerClient;

    public ApmServerHealthChecker(ApmServerClient apmServerClient) {
        this.apmServerClient = apmServerClient;
    }

    public Future<Version> checkHealthAndGetMinVersion() {
        ThreadPoolExecutor pool = ExecutorUtils.createSingleThreadDaemonPool("server-healthcheck", 1);
        try {
            Future<Version> future = pool.submit(this);
            return future;
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    @Nullable
    public Version call() {
        List<Version> versions = this.apmServerClient.executeForAllUrls("/", new ApmServerClient.ConnectionHandler<Version>(){

            @Override
            public Version withConnection(HttpURLConnection connection) {
                try {
                    int status;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Starting healthcheck to {}", (Object)connection.getURL());
                    }
                    if ((status = connection.getResponseCode()) >= 300) {
                        if (status == 404) {
                            throw new IllegalStateException("It seems like you are using a version of the APM Server which is not compatible with this agent. Please use APM Server 6.5.0 or newer.");
                        }
                        throw new IllegalStateException("Server returned status " + status);
                    }
                    try {
                        String body = HttpUtils.readToString(connection.getInputStream());
                        logger.info("Elastic APM server is available: {}", (Object)body);
                        Version version = ApmServerHealthChecker.parseVersion(body);
                        if (logger.isDebugEnabled()) {
                            logger.debug("APM server {} version is: {}", (Object)connection.getURL(), (Object)version);
                        }
                        return version;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to parse version of APM server {}: {}", (Object)connection.getURL(), (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    logger.warn("Elastic APM server {} is not available ({})", (Object)connection.getURL(), (Object)e.getMessage());
                }
                return null;
            }
        });
        versions.remove(null);
        if (!versions.isEmpty()) {
            return Collections.min(versions);
        }
        return Version.UNKNOWN_VERSION;
    }

    static Version parseVersion(String body) throws IOException {
        String versionString;
        JsonReader<Object> reader = dslJson.newReader(body.getBytes(StandardCharsets.UTF_8));
        reader.startObject();
        try {
            LinkedHashMap<String, Object> responseJsonMap = ObjectConverter.deserializeMap(reader);
            versionString = (String)Objects.requireNonNull(responseJsonMap.get("version"));
        }
        catch (Exception e) {
            reader = dslJson.newReader(body.getBytes(StandardCharsets.UTF_8));
            reader.startObject();
            LinkedHashMap<String, Object> root = ObjectConverter.deserializeMap(reader);
            versionString = (String)((Map)root.get("ok")).get("version");
        }
        return Version.of(versionString);
    }
}

