/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.CountingOutputStream;
import co.elastic.apm.agent.report.HttpUtils;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.util.IOUtils;

public class AbstractIntakeApiHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Object WAIT_LOCK = new Object();
    protected final ReporterConfiguration reporterConfiguration;
    protected final PayloadSerializer payloadSerializer;
    protected final ApmServerClient apmServerClient;
    protected Deflater deflater;
    protected long currentlyTransmitting = 0L;
    protected long reported = 0L;
    protected long dropped = 0L;
    @Nullable
    protected HttpURLConnection connection;
    @Nullable
    protected OutputStream os;
    @Nullable
    private CountingOutputStream countingOs;
    protected int errorCount;
    protected volatile boolean shutDown;
    private volatile boolean healthy = true;
    private long requestStartedNanos;

    public AbstractIntakeApiHandler(ReporterConfiguration reporterConfiguration, PayloadSerializer payloadSerializer, ApmServerClient apmServerClient) {
        this.reporterConfiguration = reporterConfiguration;
        this.payloadSerializer = payloadSerializer;
        this.apmServerClient = apmServerClient;
        this.deflater = new Deflater(1);
    }

    static long getRandomJitter(long backoffTimeMillis) {
        long tenPercentOfBackoffTimeMillis = (long)((double)backoffTimeMillis * 0.1);
        return (long)((double)(tenPercentOfBackoffTimeMillis * 2L) * Math.random()) - tenPercentOfBackoffTimeMillis;
    }

    static long getBackoffTimeSeconds(long errorCount) {
        return (long)Math.pow(Math.min(errorCount, 6L), 2.0);
    }

    protected boolean shouldEndRequest() {
        boolean endRequest;
        if (this.countingOs == null) {
            return false;
        }
        long written = this.countingOs.getCount() + (long)this.payloadSerializer.getBufferSize();
        boolean bl = endRequest = written >= this.reporterConfiguration.getApiRequestSize();
        if (endRequest && this.logger.isDebugEnabled()) {
            this.logger.debug("Flushing, because request size limit exceeded {}/{}", (Object)written, (Object)this.reporterConfiguration.getApiRequestSize());
        }
        return endRequest;
    }

    @Nullable
    protected HttpURLConnection startRequest(String endpoint) throws Exception {
        this.payloadSerializer.blockUntilReady();
        HttpURLConnection connection = this.apmServerClient.startRequest(endpoint);
        if (connection != null) {
            boolean useCompression = !this.isLocalhost(connection);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Starting new request to {}", (Object)connection.getURL());
                }
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(16384);
                if (useCompression) {
                    connection.setRequestProperty("Content-Encoding", "deflate");
                }
                connection.setRequestProperty("Content-Type", "application/x-ndjson");
                connection.setUseCaches(false);
                connection.connect();
                this.countingOs = new CountingOutputStream(connection.getOutputStream());
                this.os = useCompression ? new DeflaterOutputStream((OutputStream)this.countingOs, this.deflater, true) : this.countingOs;
                this.payloadSerializer.setOutputStream(this.os);
                this.payloadSerializer.appendMetaDataNdJsonToStream();
                this.payloadSerializer.flushToOutputStream();
                this.requestStartedNanos = System.nanoTime();
            }
            catch (IOException e) {
                this.logger.error("Error trying to connect to APM Server at {}. Some details about SSL configurations corresponding the current connection are logged at INFO level.", (Object)connection.getURL());
                if (this.logger.isInfoEnabled() && connection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
                    try {
                        this.logger.info("Cipher suite used for this connection: {}", (Object)httpsURLConnection.getCipherSuite());
                    }
                    catch (Exception e1) {
                        SSLSocketFactory sslSocketFactory = httpsURLConnection.getSSLSocketFactory();
                        this.logger.info("Default cipher suites: {}", (Object)Arrays.toString(sslSocketFactory.getDefaultCipherSuites()));
                        this.logger.info("Supported cipher suites: {}", (Object)Arrays.toString(sslSocketFactory.getSupportedCipherSuites()));
                    }
                    try {
                        this.logger.info("APM Server certificates: {}", (Object)Arrays.toString(httpsURLConnection.getServerCertificates()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.logger.info("Local certificates: {}", (Object)Arrays.toString(httpsURLConnection.getLocalCertificates()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return connection;
    }

    private boolean isLocalhost(HttpURLConnection connection) {
        switch (connection.getURL().getHost()) {
            case "localhost": 
            case "127.0.0.1": 
            case "[::1]": 
            case "[0:0:0:0:0:0:0:1]": {
                return true;
            }
        }
        return false;
    }

    public void endRequest() {
        if (this.connection != null) {
            try {
                this.payloadSerializer.fullFlush();
                if (this.os != null) {
                    this.os.close();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Flushing {} uncompressed {} compressed bytes", (Object)this.deflater.getBytesRead(), (Object)this.deflater.getBytesWritten());
                }
                InputStream inputStream = this.connection.getInputStream();
                int responseCode = this.connection.getResponseCode();
                if (responseCode >= 400) {
                    this.onRequestError(responseCode, inputStream, null);
                } else {
                    this.onRequestSuccess();
                }
            }
            catch (IOException e) {
                try {
                    this.onRequestError(this.connection.getResponseCode(), this.connection.getErrorStream(), e);
                }
                catch (IOException e1) {
                    this.onRequestError(-1, this.connection.getErrorStream(), e);
                }
            }
            finally {
                HttpUtils.consumeAndClose(this.connection);
                this.connection = null;
                this.os = null;
                this.countingOs = null;
                this.deflater.reset();
                this.currentlyTransmitting = 0L;
            }
        }
    }

    protected boolean isApiRequestTimeExpired() {
        return System.nanoTime() >= this.requestStartedNanos + TimeUnit.MILLISECONDS.toNanos(this.reporterConfiguration.getApiRequestTime().getMillis());
    }

    protected void onRequestError(Integer responseCode, InputStream inputStream, @Nullable IOException e) {
        this.onConnectionError(responseCode, this.currentlyTransmitting, 0L);
        if (e != null) {
            this.logger.error("Error sending data to APM server: {}, response code is {}", (Object)e.getMessage(), (Object)responseCode);
            this.logger.debug("Sending payload to APM server failed", e);
        }
        if (this.logger.isWarnEnabled()) {
            try {
                this.logger.warn(IOUtils.toString(inputStream));
            }
            catch (IOException e1) {
                this.logger.warn(e1.getMessage(), e);
            }
        }
    }

    protected void onConnectionError(@Nullable Integer responseCode, long droppedEvents, long reportedEvents) {
        this.dropped += droppedEvents;
        this.reported += reportedEvents;
        if (responseCode == null || responseCode > 429) {
            this.apmServerClient.onConnectionError();
        } else if (responseCode == 404) {
            this.logger.warn("It seems like you are using a version of the APM Server which is not compatible with this agent. Please use APM Server 6.5.0 or newer.");
        }
        this.backoff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backoff() {
        long backoffTimeSeconds = AbstractIntakeApiHandler.getBackoffTimeSeconds(this.errorCount++);
        this.logger.info("Backing off for {} seconds (+/-10%)", (Object)backoffTimeSeconds);
        long backoffTimeMillis = TimeUnit.SECONDS.toMillis(backoffTimeSeconds);
        if (backoffTimeMillis > 0L) {
            try {
                this.healthy = false;
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.wait(backoffTimeMillis + AbstractIntakeApiHandler.getRandomJitter(backoffTimeMillis));
                }
            }
            catch (InterruptedException e) {
                this.logger.info("APM Agent ReportingEventHandler had been interrupted", e);
            }
            finally {
                this.healthy = true;
            }
        }
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public long getReported() {
        return this.reported;
    }

    public long getDropped() {
        return this.dropped;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.shutDown = true;
        Object object = WAIT_LOCK;
        synchronized (object) {
            WAIT_LOCK.notifyAll();
        }
    }

    protected void onRequestSuccess() {
        this.errorCount = 0;
        this.reported += this.currentlyTransmitting;
    }
}

