/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redisson;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;

public class RedisConnectionInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.redisson.client.RedisConnection").and(ElementMatchers.declaresMethod(ElementMatchers.named("getChannel")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("send");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "redisson");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(inline=false)
        public static Object beforeSend(@Advice.This RedisConnection connection, @Advice.Argument(value=0) Object args) {
            Span span = RedisSpanUtils.createRedisSpan("");
            if (span != null) {
                if (args instanceof CommandsData) {
                    List commands = ((CommandsData)args).getCommands();
                    if (commands != null && !commands.isEmpty()) {
                        ((Span)span.appendToName(((CommandData)commands.get(0)).getCommand().getName())).appendToName("... [bulk]");
                    }
                } else if (args instanceof CommandData) {
                    span.appendToName(((CommandData)args).getCommand().getName());
                }
                Channel channel = connection.getChannel();
                InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
                span.getContext().getDestination().withInetAddress(remoteAddress.getAddress()).withPort(remoteAddress.getPort());
            }
            return span;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void afterSend(@Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
            Span span = (Span)spanObj;
            if (span != null) {
                ((Span)((Span)span.captureException(thrown)).deactivate()).end();
            }
        }
    }
}

