/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler.asyncprofiler;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;

class BufferedFile
implements Recyclable {
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private ByteBuffer buffer;
    private final ByteBuffer bigBuffer;
    private final ByteBuffer smallBuffer;
    private long offset;
    private boolean wholeFileInBuffer;
    @Nullable
    private FileChannel fileChannel;

    public BufferedFile(ByteBuffer bigBuffer, ByteBuffer smallBuffer) {
        this.bigBuffer = bigBuffer;
        this.smallBuffer = smallBuffer;
    }

    public void setFile(File file) throws IOException {
        this.fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        if (this.fileChannel.size() <= (long)this.bigBuffer.capacity()) {
            this.buffer = this.bigBuffer;
            this.read(0L, this.bigBuffer.capacity());
            this.wholeFileInBuffer = true;
        } else {
            ByteBuffer buffer = this.buffer = this.smallBuffer;
            ((Buffer)buffer).flip();
        }
    }

    public long position() {
        return this.offset + (long)this.buffer.position();
    }

    public void skip(int bytesToSkip) {
        this.position(this.position() + (long)bytesToSkip);
    }

    public void position(long pos) {
        ByteBuffer buffer = this.buffer;
        long positionDelta = pos - this.position();
        long newBufferPos = (long)buffer.position() + positionDelta;
        if (0L <= newBufferPos && newBufferPos <= (long)buffer.limit()) {
            ((Buffer)buffer).position((int)newBufferPos);
        } else {
            ((Buffer)buffer).position(0);
            ((Buffer)buffer).limit(0);
            this.offset = pos;
        }
    }

    public void ensureRemaining(int minRemaining) throws IOException {
        this.ensureRemaining(minRemaining, this.buffer.capacity());
    }

    public void ensureRemaining(int minRemaining, int maxRead) throws IOException {
        if (this.wholeFileInBuffer) {
            return;
        }
        if (minRemaining > this.buffer.capacity()) {
            throw new IllegalStateException(String.format("Length (%d) greater than buffer capacity (%d)", minRemaining, this.buffer.capacity()));
        }
        if (this.buffer.remaining() < minRemaining) {
            this.read(this.position(), maxRead);
        }
    }

    public short get() throws IOException {
        this.ensureRemaining(1);
        return this.buffer.get();
    }

    public short getShort() throws IOException {
        this.ensureRemaining(2);
        return this.buffer.getShort();
    }

    public int getUnsignedShort() throws IOException {
        return this.getShort() & 0xFFFF;
    }

    public int getInt() throws IOException {
        this.ensureRemaining(4);
        return this.buffer.getInt();
    }

    public long getLong() throws IOException {
        this.ensureRemaining(8);
        return this.buffer.getLong();
    }

    public byte getUnsafe() {
        return this.buffer.get();
    }

    public short getUnsafeShort() {
        return this.buffer.getShort();
    }

    public int getUnsafeInt() {
        return this.buffer.getInt();
    }

    public long getUnsafeLong() {
        return this.buffer.getLong();
    }

    public long size() throws IOException {
        if (this.fileChannel == null) {
            throw new IllegalStateException("setFile has not been called yet");
        }
        return this.fileChannel.size();
    }

    public boolean isSet() {
        return this.fileChannel != null;
    }

    @Override
    public void resetState() {
        if (this.fileChannel == null) {
            throw new IllegalStateException("setFile has not been called yet");
        }
        ByteBuffer buffer = this.buffer;
        ((Buffer)buffer).clear();
        this.offset = 0L;
        this.wholeFileInBuffer = false;
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileChannel = null;
        this.buffer = null;
    }

    private void read(long offset, int limit) throws IOException {
        if (limit > this.buffer.capacity()) {
            limit = this.buffer.capacity();
        }
        ByteBuffer buffer = this.buffer;
        ((Buffer)buffer).clear();
        this.fileChannel.position(offset);
        ((Buffer)buffer).limit(limit);
        this.fileChannel.read(this.buffer);
        ((Buffer)buffer).flip();
        this.offset = offset;
    }
}

