/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.process.BaseProcessInstrumentation;
import co.elastic.apm.agent.process.ProcessHelper;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ProcessExitInstrumentation
extends BaseProcessInstrumentation {
    @Override
    public final ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("java.lang.ProcessImpl").or(ElementMatchers.named("java.lang.UNIXProcess"));
    }

    public static class ExitValue
    extends ProcessExitInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("exitValue"));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.process.ProcessExitInstrumentation$ExitValue$ExitValueAdvice";
        }

        public static class ExitValueAdvice {
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.This Process process, @Advice.Thrown Throwable thrown, @Advice.Return int exitValue) {
                if (ProcessHelper.isTracingOnCurrentThread() || TracerAwareInstrumentation.tracer.getActive() == null) {
                    return;
                }
                if (thrown instanceof IllegalThreadStateException) {
                    return;
                }
                ProcessHelper.endProcessSpan(process, exitValue);
            }
        }
    }

    public static class Destroy
    extends ProcessExitInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("destroy").or(ElementMatchers.named("destroyForcibly")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.process.ProcessExitInstrumentation$Destroy$DestroyAdvice";
        }

        public static class DestroyAdvice {
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.This Process process) {
                if (TracerAwareInstrumentation.tracer.getActive() == null) {
                    return;
                }
                ProcessHelper.endProcess(process, false);
            }
        }
    }

    public static class WaitFor
    extends ProcessExitInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("waitFor");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.process.ProcessExitInstrumentation$WaitFor$WaitForAdvice";
        }

        public static class WaitForAdvice {
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.This Process process) {
                if (TracerAwareInstrumentation.tracer.getActive() == null) {
                    return;
                }
                ProcessHelper.endProcess(process, true);
            }
        }
    }
}

