/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.pluginapi.ApiInstrumentation;
import co.elastic.apm.agent.pluginapi.HeaderExtractorBridge;
import co.elastic.apm.agent.pluginapi.HeadersExtractorBridge;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ElasticApmApiInstrumentation
extends ApiInstrumentation {
    static final String PUBLIC_API_INSTRUMENTATION_GROUP = "public-api";
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    ElasticApmApiInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.ElasticApm");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CaptureExceptionInstrumentation
    extends ElasticApmApiInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void captureException(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) @Nullable Throwable e) {
                TracerAwareInstrumentation.tracer.captureAndReportException(e, clazz.getClassLoader());
            }
        }
    }

    public static class CurrentSpanInstrumentation
    extends ElasticApmApiInstrumentation {
        public CurrentSpanInstrumentation() {
            super(ElementMatchers.named("doGetCurrentSpan"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object doGetCurrentSpan() {
                return TracerAwareInstrumentation.tracer.getActive();
            }
        }
    }

    public static class CurrentTransactionInstrumentation
    extends ElasticApmApiInstrumentation {
        public CurrentTransactionInstrumentation() {
            super(ElementMatchers.named("doGetCurrentTransaction"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object doGetCurrentTransaction() {
                return TracerAwareInstrumentation.tracer.currentTransaction();
            }
        }
    }

    public static class StartTransactionWithRemoteParentInstrumentation
    extends ElasticApmApiInstrumentation {
        public StartTransactionWithRemoteParentInstrumentation() {
            super(ElementMatchers.named("doStartTransactionWithRemoteParentFunction"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object doStartTransaction(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) MethodHandle getFirstHeader, @Advice.Argument(value=1) @Nullable Object headerExtractor, @Advice.Argument(value=2) MethodHandle getAllHeaders, @Advice.Argument(value=3) @Nullable Object headersExtractor) {
                Transaction transaction = null;
                if (headersExtractor != null) {
                    HeadersExtractorBridge headersExtractorBridge = HeadersExtractorBridge.get(getFirstHeader, getAllHeaders);
                    transaction = TracerAwareInstrumentation.tracer.startChildTransaction(HeadersExtractorBridge.Extractor.of(headerExtractor, headersExtractor), headersExtractorBridge, clazz.getClassLoader());
                } else if (headerExtractor != null) {
                    HeaderExtractorBridge headersExtractorBridge = HeaderExtractorBridge.get(getFirstHeader);
                    transaction = TracerAwareInstrumentation.tracer.startChildTransaction(headerExtractor, headersExtractorBridge, clazz.getClassLoader());
                } else {
                    transaction = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader());
                }
                if (transaction != null) {
                    transaction.setFrameworkName("API");
                }
                return transaction;
            }
        }
    }

    public static class StartTransactionInstrumentation
    extends ElasticApmApiInstrumentation {
        public StartTransactionInstrumentation() {
            super(ElementMatchers.named("doStartTransaction"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object doStartTransaction(@Advice.Origin Class<?> clazz) {
                Transaction transaction = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader());
                if (transaction != null) {
                    transaction.setFrameworkName("API");
                }
                return transaction;
            }
        }
    }
}

