/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureSpanInstrumentation
extends TracerAwareInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(CaptureSpanInstrumentation.class);
    private final CoreConfiguration coreConfig;
    private final StacktraceConfiguration stacktraceConfig;

    public CaptureSpanInstrumentation(ElasticApmTracer tracer) {
        this.coreConfig = tracer.getConfig(CoreConfiguration.class);
        this.stacktraceConfig = tracer.getConfig(StacktraceConfiguration.class);
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("co.elastic.apm.api.CaptureSpan");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.stacktraceConfig.getApplicationPackages(), ElementMatchers.none()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        if (this.coreConfig.isEnablePublicApiAnnotationInheritance()) {
            return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.CaptureSpan")));
        }
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.CaptureSpan"));
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return false;
    }

    @Override
    public final Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("public-api", "annotations");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onMethodEnter(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="value") String spanName, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="type") String type, @Nullable @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="subtype") String subtype, @Nullable @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="action") String action) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent != null) {
                Span span = (Span)((Span)parent.createSpan().withName(spanName.isEmpty() ? signature : spanName)).activate();
                span.setType(type, subtype, action);
                return span;
            }
            logger.debug("Not creating span for {} because there is no currently active span.", (Object)signature);
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object span, @Advice.Thrown @Nullable Throwable t) {
            if (span instanceof Span) {
                ((Span)((Span)((Span)((Span)span).captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }
    }
}

