/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracingimpl;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.opentracingimpl.OpenTracingBridgeInstrumentation;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ScopeManagerInstrumentation
extends OpenTracingBridgeInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ScopeManagerInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmScopeManager");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CurrentTraceContextInstrumentation
    extends ScopeManagerInstrumentation {
        public CurrentTraceContextInstrumentation() {
            super(ElementMatchers.named("getCurrentTraceContext"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object getCurrentTraceContext() {
                return TracerAwareInstrumentation.tracer.getActive();
            }
        }
    }

    public static class CurrentSpanInstrumentation
    extends ScopeManagerInstrumentation {
        public CurrentSpanInstrumentation() {
            super(ElementMatchers.named("getCurrentSpan"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object getCurrentSpan() {
                return TracerAwareInstrumentation.tracer.getActive();
            }
        }
    }

    public static class ActivateInstrumentation
    extends ScopeManagerInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("doActivate"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void doActivate(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable Object context) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).activate();
                }
            }
        }
    }
}

