/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracingimpl;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import java.util.Map;
import javax.annotation.Nullable;

public class OpenTracingTextMapBridge
implements TextHeaderGetter<Iterable<Map.Entry<String, String>>>,
TextHeaderSetter<Map<String, String>> {
    private static final OpenTracingTextMapBridge INSTANCE = new OpenTracingTextMapBridge();

    public static OpenTracingTextMapBridge instance() {
        return INSTANCE;
    }

    private OpenTracingTextMapBridge() {
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Iterable<Map.Entry<String, String>> textMap) {
        for (Map.Entry<String, String> entry : textMap) {
            if (!entry.getKey().equalsIgnoreCase(headerName)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, Iterable<Map.Entry<String, String>> carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        for (Map.Entry<String, String> entry : carrier) {
            if (!entry.getKey().equalsIgnoreCase(headerName)) continue;
            consumer.accept(entry.getValue(), state);
        }
    }

    @Override
    public void setHeader(String headerName, String headerValue, Map<String, String> textMap) {
        textMap.put(headerName, headerValue);
    }
}

