/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracingimpl;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.sampling.ConstantSampler;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentracingimpl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.opentracingimpl.OpenTracingTextMapBridge;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApmSpanBuilderInstrumentation
extends OpenTracingBridgeInstrumentation {
    private static final String FRAMEWORK_NAME = "OpenTracing";
    private static final Logger logger = LoggerFactory.getLogger(ApmSpanBuilderInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ApmSpanBuilderInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmSpanBuilder");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CreateSpanInstrumentation
    extends ApmSpanBuilderInstrumentation {
        public CreateSpanInstrumentation() {
            super(ElementMatchers.named("createSpan"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object createSpan(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable Object parentContext, @Advice.Origin Class<?> spanBuilderClass, @Advice.FieldValue(value="tags") Map<String, Object> tags, @Advice.FieldValue(value="operationName") String operationName, @Advice.FieldValue(value="microseconds") long microseconds, @Advice.Argument(value=1) @Nullable Iterable<Map.Entry<String, String>> baggage) {
                AbstractSpan parent = null;
                if (parentContext instanceof AbstractSpan) {
                    parent = (AbstractSpan)parentContext;
                }
                return AdviceClass.doCreateTransactionOrSpan(parent, tags, operationName, microseconds, baggage, spanBuilderClass.getClassLoader());
            }

            @Nullable
            public static AbstractSpan<?> doCreateTransactionOrSpan(@Nullable AbstractSpan<?> parentContext, Map<String, Object> tags, String operationName, long microseconds, @Nullable Iterable<Map.Entry<String, String>> baggage, ClassLoader applicationClassLoader) {
                Span result = null;
                ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
                if (tracer != null) {
                    result = parentContext == null ? AdviceClass.createTransaction(tags, operationName, microseconds, baggage, tracer, applicationClassLoader) : (microseconds >= 0L ? tracer.startSpan(TraceContext.fromParent(), parentContext, microseconds) : tracer.startSpan(TraceContext.fromParent(), parentContext));
                }
                if (result != null) {
                    ((AbstractSpan)result).incrementReferences();
                }
                return result;
            }

            @Nullable
            private static AbstractSpan<?> createTransaction(Map<String, Object> tags, String operationName, long microseconds, @Nullable Iterable<Map.Entry<String, String>> baggage, ElasticApmTracer tracer, ClassLoader classLoader) {
                if ("client".equals(tags.get("span.kind"))) {
                    logger.info("Ignoring transaction '{}', as a span.kind client can never be a transaction. Consider creating a span for the whole request.", (Object)operationName);
                    return tracer.noopTransaction();
                }
                Object samplingPriority = tags.get("sampling.priority");
                Sampler sampler = samplingPriority instanceof Number ? ConstantSampler.of(((Number)samplingPriority).intValue() > 0) : tracer.getSampler();
                Transaction transaction = tracer.startChildTransaction(baggage, OpenTracingTextMapBridge.instance(), sampler, microseconds, classLoader);
                if (transaction != null) {
                    transaction.setFrameworkName(ApmSpanBuilderInstrumentation.FRAMEWORK_NAME);
                }
                return transaction;
            }
        }
    }
}

