/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.JmsMessagePropertyAccessor;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import java.util.Enumeration;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsInstrumentationHelper {
    protected static String JMS_TRACE_PARENT_PROPERTY = "elastic-apm-traceparent".replace('-', '_');
    protected static String JMS_DESTINATION_NAME_PROPERTY = "elastic_apm_dest_name";
    protected static String MESSAGE_HANDLING = "message-handling";
    protected static String MESSAGE_POLLING = "message-polling";
    protected static String MESSAGING_TYPE = "messaging";
    protected static String RECEIVE_NAME_PREFIX = "JMS RECEIVE";
    protected static String JMS_MESSAGE_ID_HEADER = "JMSMessageID";
    protected static String JMS_EXPIRATION_HEADER = "JMSExpiration";
    protected static String JMS_TIMESTAMP_HEADER = "JMSTimestamp";
    static final String TIBCO_TMP_QUEUE_PREFIX = "$TMP$";
    static final String TEMP = "<temporary>";
    static final String FRAMEWORK_NAME = "JMS";
    private static final Logger logger = LoggerFactory.getLogger(JmsInstrumentationHelper.class);
    private final ElasticApmTracer tracer;
    private final CoreConfiguration coreConfiguration;
    private final MessagingConfiguration messagingConfiguration;

    public JmsInstrumentationHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.messagingConfiguration = tracer.getConfig(MessagingConfiguration.class);
    }

    @Nullable
    public Span startJmsSendSpan(Destination destination, javax.jms.Message message) {
        AbstractSpan<?> activeSpan = this.tracer.getActive();
        if (activeSpan == null) {
            return null;
        }
        boolean isDestinationNameComputed = false;
        String destinationName = this.extractDestinationName(null, destination);
        if (this.isTempDestination(destination, destinationName)) {
            destinationName = TEMP;
            isDestinationNameComputed = true;
        }
        if (this.ignoreDestination(destinationName)) {
            return null;
        }
        Span span = activeSpan.createExitSpan();
        if (span == null) {
            return null;
        }
        span.withType(MESSAGING_TYPE).withSubtype("jms").withAction("send").activate();
        span.propagateTraceContext(message, JmsMessagePropertyAccessor.instance());
        if (span.isSampled()) {
            span.getContext().getDestination().getService().withName("jms").withResource("jms").withType(MESSAGING_TYPE);
            if (destinationName != null) {
                span.getContext().getDestination().getService().getResource().append("/").append(destinationName);
                span.withName("JMS SEND to ");
                this.addDestinationDetails(destination, destinationName, span);
                if (isDestinationNameComputed) {
                    JmsMessagePropertyAccessor.instance().setHeader(JMS_DESTINATION_NAME_PROPERTY, destinationName, message);
                }
            }
        }
        return span;
    }

    @Nullable
    public Transaction startJmsTransaction(javax.jms.Message parentMessage, Class<?> instrumentedClass) {
        Transaction transaction = this.tracer.startChildTransaction(parentMessage, JmsMessagePropertyAccessor.instance(), instrumentedClass.getClassLoader());
        if (transaction != null) {
            transaction.setFrameworkName(FRAMEWORK_NAME);
        }
        return transaction;
    }

    public void makeChildOf(Transaction childTransaction, javax.jms.Message parentMessage) {
        TraceContext.getFromTraceContextTextHeaders().asChildOf(childTransaction.getTraceContext(), parentMessage, JmsMessagePropertyAccessor.instance());
    }

    @Nullable
    public MessageListener wrapLambda(@Nullable MessageListener listener) {
        if (listener != null && listener.getClass().getName().contains("/")) {
            return new MessageListenerWrapper(listener);
        }
        return listener;
    }

    @Nullable
    public String extractDestinationName(@Nullable javax.jms.Message message, Destination destination) {
        String destinationName = null;
        if (message != null) {
            destinationName = JmsMessagePropertyAccessor.instance().getFirstHeader(JMS_DESTINATION_NAME_PROPERTY, message);
        }
        if (destinationName == null) {
            try {
                if (destination instanceof Queue) {
                    destinationName = ((Queue)destination).getQueueName();
                } else if (destination instanceof Topic) {
                    destinationName = ((Topic)destination).getTopicName();
                }
            }
            catch (JMSException e) {
                logger.error("Failed to obtain destination name", e);
            }
        }
        return destinationName;
    }

    private boolean isTempDestination(Destination destination, @Nullable String extractedDestinationName) {
        return destination instanceof TemporaryQueue || destination instanceof TemporaryTopic || extractedDestinationName != null && extractedDestinationName.startsWith(TIBCO_TMP_QUEUE_PREFIX);
    }

    public boolean ignoreDestination(@Nullable String destinationName) {
        return WildcardMatcher.isAnyMatch(this.messagingConfiguration.getIgnoreMessageQueues(), destinationName);
    }

    public void addDestinationDetails(Destination destination, String destinationName, AbstractSpan<?> span) {
        String prefix = null;
        if (destination instanceof Queue) {
            prefix = "queue ";
        } else if (destination instanceof Topic) {
            prefix = "topic ";
        }
        if (prefix != null) {
            ((AbstractSpan)((AbstractSpan)span.appendToName(prefix)).appendToName(destinationName)).getContext().getMessage().withQueue(destinationName);
        }
    }

    public void setMessageAge(javax.jms.Message message, AbstractSpan<?> span) {
        long messageTimestamp = -1L;
        try {
            messageTimestamp = message.getJMSTimestamp();
        }
        catch (JMSException e) {
            logger.warn("Failed to get message timestamp", e);
        }
        if (messageTimestamp > 0L) {
            long now = System.currentTimeMillis();
            long age = now > messageTimestamp ? now - messageTimestamp : 0L;
            span.getContext().getMessage().withAge(age);
        }
    }

    public void addMessageDetails(@Nullable javax.jms.Message message, AbstractSpan<?> span) {
        if (message == null) {
            return;
        }
        try {
            Message messageContext = span.getContext().getMessage();
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && message instanceof TextMessage) {
                messageContext.withBody(((TextMessage)message).getText());
            }
            if (this.coreConfiguration.isCaptureHeaders()) {
                messageContext.addHeader(JMS_MESSAGE_ID_HEADER, message.getJMSMessageID());
                messageContext.addHeader(JMS_EXPIRATION_HEADER, String.valueOf(message.getJMSExpiration()));
                messageContext.addHeader(JMS_TIMESTAMP_HEADER, String.valueOf(message.getJMSTimestamp()));
                Enumeration properties = message.getPropertyNames();
                if (properties != null) {
                    while (properties.hasMoreElements()) {
                        String propertyName = String.valueOf(properties.nextElement());
                        if (propertyName.equals(JMS_DESTINATION_NAME_PROPERTY) || propertyName.equals(JMS_TRACE_PARENT_PROPERTY) || WildcardMatcher.anyMatch(this.coreConfiguration.getSanitizeFieldNames(), propertyName) != null) continue;
                        messageContext.addHeader(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
                    }
                }
            }
        }
        catch (JMSException e) {
            logger.warn("Failed to retrieve message details", e);
        }
    }

    public static class MessageListenerWrapper
    implements MessageListener {
        private final MessageListener delegate;

        MessageListenerWrapper(MessageListener delegate) {
            this.delegate = delegate;
        }

        public void onMessage(javax.jms.Message message) {
            this.delegate.onMessage(message);
        }
    }
}

