/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jedis;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JedisSpanNameInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("redis.clients.jedis.Protocol");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("sendCommand").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("RedisOutputStream"))).and(ElementMatchers.takesArgument(1, ElementMatchers.nameEndsWith("Command"))).and(ElementMatchers.takesArgument(2, byte[][].class));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "jedis");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(inline=false)
        public static void setSpanNameToRedisProtocolCommand(@Advice.Argument(value=1) Object command) {
            Span activeSpan;
            AbstractSpan<?> active = TracerAwareInstrumentation.tracer.getActive();
            if (active instanceof Span && "redis".equals((activeSpan = (Span)active).getSubtype())) {
                activeSpan.withName(command.toString());
            }
        }
    }
}

