/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.db.signature.Scanner;
import co.elastic.apm.agent.db.signature.SignatureParser;
import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jdbc.JdbcFilter;
import co.elastic.apm.agent.jdbc.helper.ConnectionMetaData;
import co.elastic.apm.agent.jdbc.helper.JdbcGlobalState;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcHelper {
    private static final Logger logger = LoggerFactory.getLogger(JdbcHelper.class);
    public static final String DB_SPAN_TYPE = "db";
    public static final String DB_SPAN_ACTION = "query";
    private static final JdbcHelper INSTANCE = new JdbcHelper();
    private final SignatureParser signatureParser = new SignatureParser(new Callable<Scanner>(){

        @Override
        public Scanner call() {
            return new Scanner(new JdbcFilter());
        }
    });

    public static JdbcHelper get() {
        return INSTANCE;
    }

    public void mapStatementToSql(Object statement, String sql) {
        JdbcGlobalState.statementSqlMap.putIfAbsent(statement, sql);
    }

    @Nullable
    public String retrieveSqlForStatement(Object statement) {
        return JdbcGlobalState.statementSqlMap.get(statement);
    }

    @Nullable
    public Span createJdbcSpan(@Nullable String sql, Object statement, @Nullable AbstractSpan<?> parent, boolean preparedStatement) {
        StringBuilder spanName;
        if (!(statement instanceof Statement) || sql == null || this.isAlreadyMonitored(parent) || parent == null) {
            return null;
        }
        Span span = (Span)parent.createSpan().activate();
        if (sql.isEmpty()) {
            span.withName("empty query");
        } else if (span.isSampled() && (spanName = span.getAndOverrideName(0)) != null) {
            this.signatureParser.querySignature(sql, spanName, preparedStatement);
        }
        span.withType(DB_SPAN_TYPE);
        span.getContext().getDb().withStatement(sql.isEmpty() ? "(empty query)" : sql).withType("sql");
        Connection connection = this.safeGetConnection((Statement)statement);
        ConnectionMetaData connectionMetaData = this.getConnectionMetaData(connection);
        String vendor = "unknown";
        if (connectionMetaData != null) {
            vendor = connectionMetaData.getDbVendor();
            span.getContext().getDb().withInstance(connectionMetaData.getInstance()).withUser(connectionMetaData.getUser());
            Destination destination = span.getContext().getDestination().withAddress(connectionMetaData.getHost()).withPort(connectionMetaData.getPort());
            destination.getService().withName(vendor).withResource(vendor).withType(DB_SPAN_TYPE);
        }
        span.withSubtype(vendor).withAction(DB_SPAN_ACTION);
        return span;
    }

    private boolean isAlreadyMonitored(@Nullable AbstractSpan<?> parent) {
        if (!(parent instanceof Span)) {
            return false;
        }
        Span parentSpan = (Span)parent;
        return parentSpan.getType() != null && parentSpan.getType().equals(DB_SPAN_TYPE);
    }

    @Nullable
    private ConnectionMetaData getConnectionMetaData(@Nullable Connection connection) {
        if (null == connection) {
            return null;
        }
        ConnectionMetaData connectionMetaData = JdbcGlobalState.metaDataMap.get(connection);
        if (connectionMetaData != null) {
            return connectionMetaData;
        }
        Class<?> type = connection.getClass();
        Boolean supported = JdbcHelper.isSupported(JdbcFeature.METADATA, type);
        if (supported == Boolean.FALSE) {
            return null;
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            connectionMetaData = ConnectionMetaData.create(metaData.getURL(), connection.getCatalog(), metaData.getUserName());
            if (supported == null) {
                JdbcHelper.markSupported(JdbcFeature.METADATA, type);
            }
        }
        catch (SQLException e) {
            JdbcHelper.markNotSupported(JdbcFeature.METADATA, type, e);
        }
        if (connectionMetaData != null) {
            JdbcGlobalState.metaDataMap.put(connection, connectionMetaData);
        }
        return connectionMetaData;
    }

    @Nullable
    private Connection safeGetConnection(Statement statement) {
        Connection connection = null;
        Class<?> type = statement.getClass();
        Boolean supported = JdbcHelper.isSupported(JdbcFeature.CONNECTION, type);
        if (supported == Boolean.FALSE) {
            return null;
        }
        try {
            connection = statement.getConnection();
            if (supported == null) {
                JdbcHelper.markSupported(JdbcFeature.CONNECTION, type);
            }
        }
        catch (SQLException e) {
            JdbcHelper.markNotSupported(JdbcFeature.CONNECTION, type, e);
        }
        return connection;
    }

    @Nullable
    private static Boolean isSupported(JdbcFeature feature, Class<?> type) {
        return (Boolean)feature.classSupport.get(type);
    }

    private static void markSupported(JdbcFeature feature, Class<?> type) {
        feature.classSupport.put(type, Boolean.TRUE);
    }

    private static void markNotSupported(JdbcFeature feature, Class<?> type, SQLException e) {
        Boolean previous = feature.classSupport.put(type, Boolean.FALSE);
        if (previous == null) {
            logger.warn("JDBC feature not supported on class " + type, e);
        }
    }

    public void removeSqlForStatement(Statement statement) {
        JdbcGlobalState.statementSqlMap.remove(statement);
    }

    private static enum JdbcFeature {
        METADATA(JdbcGlobalState.metadataSupported),
        CONNECTION(JdbcGlobalState.connectionSupported);

        private final WeakMap<Class<?>, Boolean> classSupport;

        private JdbcFeature(WeakMap<Class<?>, Boolean> map) {
            this.classSupport = map;
        }
    }
}

