/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.stacktrace;

import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import java.util.Collection;
import java.util.Collections;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;

public class StacktraceConfiguration
extends ConfigurationOptionProvider {
    private static final String STACKTRACE_CATEGORY = "Stacktrace";
    public static final String APPLICATION_PACKAGES = "application_packages";
    private final ConfigurationOption<Collection<String>> applicationPackages = ConfigurationOption.stringsOption().key("application_packages").configurationCategory("Stacktrace").description("Used to determine whether a stack trace frame is an 'in-app frame' or a 'library frame'.\nThis allows the APM app to collapse the stack frames of library code,\nand highlight the stack frames that originate from your application.\nMultiple root packages can be set as a comma-separated list;\nthere's no need to configure sub-packages.\nBecause this setting helps determine which classes to scan on startup,\nsetting this option can also improve startup time.\n\nYou must set this option in order to use the API annotations `@CaptureTransaction` and `@CaptureSpan`.\n\n**Example**\n\nMost Java projects have a root package, e.g. `com.myproject`. You can set the application package using Java system properties:\n`-Delastic.apm.application_packages=com.myproject`\n\nIf you are only interested in specific subpackages, you can separate them with commas:\n`-Delastic.apm.application_packages=com.myproject.api,com.myproject.impl`").dynamic(true).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<Integer> stackTraceLimit = ConfigurationOption.integerOption().key("stack_trace_limit").tags("performance").configurationCategory("Stacktrace").description("Setting it to 0 will disable stack trace collection. Any positive integer value will be used as the maximum number of frames to collect. Setting it -1 means that all frames will be collected.").dynamic(true).buildWithDefault(50);
    private final ConfigurationOption<TimeDuration> spanFramesMinDurationMs = TimeDurationValueConverter.durationOption("ms").key("span_frames_min_duration").aliasKeys("span_frames_min_duration_ms").tags("internal", "deprecated").configurationCategory("Stacktrace").description("While this is very helpful to find the exact place in your code that causes the span, collecting this stack trace does have some overhead. \nWhen setting this option to a negative value, like `-1ms`, stack traces will be collected for all spans. Setting it to a positive value, e.g. `5ms`, will limit stack trace collection to spans with durations equal to or longer than the given value, e.g. 5 milliseconds.\n\nTo disable stack trace collection for spans completely, set the value to `0ms`.").dynamic(true).buildWithDefault(TimeDuration.of("5ms"));
    private final ConfigurationOption<TimeDuration> spanStackTraceMinDurationMs = TimeDurationValueConverter.durationOption("ms").key("span_stack_trace_min_duration").tags("performance").configurationCategory("Stacktrace").description("While this is very helpful to find the exact place in your code that causes the span, collecting this stack trace does have some overhead. \nWhen setting this option to value `0ms`, stack traces will be collected for all spans. Setting it to a positive value, e.g. `5ms`, will limit stack trace collection to spans with durations equal to or longer than the given value, e.g. 5 milliseconds.\n\nTo disable stack trace collection for spans completely, set the value to `-1ms`.").dynamic(true).buildWithDefault(TimeDuration.of("5ms"));

    public Collection<String> getApplicationPackages() {
        return this.applicationPackages.get();
    }

    public int getStackTraceLimit() {
        return this.stackTraceLimit.get();
    }

    public long getSpanStackTraceMinDurationMs() {
        if (this.spanStackTraceMinDurationMs.isDefault() && !this.spanFramesMinDurationMs.isDefault()) {
            long spanFramesMinDurationMsValue = this.spanFramesMinDurationMs.getValue().getMillis();
            if (spanFramesMinDurationMsValue == 0L) {
                return -1L;
            }
            if (spanFramesMinDurationMsValue < 0L) {
                return 0L;
            }
            return spanFramesMinDurationMsValue;
        }
        return this.spanStackTraceMinDurationMs.getValue().getMillis();
    }
}

