/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.metadata;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.metadata.CloudMetadataProvider;
import co.elastic.apm.agent.impl.metadata.CloudProviderInfo;
import co.elastic.apm.agent.impl.metadata.FaaSMetaDataExtension;
import co.elastic.apm.agent.impl.metadata.MetaDataFuture;
import co.elastic.apm.agent.impl.metadata.ProcessFactory;
import co.elastic.apm.agent.impl.metadata.ProcessInfo;
import co.elastic.apm.agent.impl.metadata.Service;
import co.elastic.apm.agent.impl.metadata.ServiceFactory;
import co.elastic.apm.agent.impl.metadata.SystemInfo;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.util.CompletableFuture;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import org.stagemonitor.configuration.ConfigurationRegistry;

public class MetaData {
    private final Service service;
    private final ProcessInfo process;
    private final SystemInfo system;
    @Nullable
    private final CloudProviderInfo cloudProviderInfo;
    private final ArrayList<String> globalLabelKeys;
    private final ArrayList<String> globalLabelValues;

    MetaData(ProcessInfo process, Service service, SystemInfo system, @Nullable CloudProviderInfo cloudProviderInfo, Map<String, String> globalLabels, @Nullable FaaSMetaDataExtension faasMetaDataExtension) {
        this.process = process;
        this.service = service;
        this.system = system;
        this.cloudProviderInfo = cloudProviderInfo;
        this.globalLabelKeys = new ArrayList<String>(globalLabels.keySet());
        this.globalLabelValues = new ArrayList<String>(globalLabels.values());
        if (faasMetaDataExtension != null) {
            if (service.getId() == null) {
                service.withId(faasMetaDataExtension.getServiceId());
            }
            if (service.getFramework() == null && faasMetaDataExtension.getFramework() != null) {
                service.withFramework(faasMetaDataExtension.getFramework());
            }
            if (cloudProviderInfo != null) {
                if (cloudProviderInfo.getAccount() == null) {
                    cloudProviderInfo.setAccount(faasMetaDataExtension.getAccount());
                }
                if (cloudProviderInfo.getRegion() == null) {
                    cloudProviderInfo.setRegion(faasMetaDataExtension.getRegion());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaDataFuture create(ConfigurationRegistry configurationRegistry, @Nullable String ephemeralId) {
        if (ephemeralId == null) {
            ephemeralId = UUID.randomUUID().toString();
        }
        final CoreConfiguration coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
        final ServerlessConfiguration serverlessConfiguration = configurationRegistry.getConfig(ServerlessConfiguration.class);
        ServiceFactory serviceFactory = new ServiceFactory();
        final Service service = serviceFactory.createService(coreConfiguration, ephemeralId, serverlessConfiguration);
        final ProcessInfo processInformation = ProcessFactory.ForCurrentVM.INSTANCE.getProcessInformation();
        if (!configurationRegistry.getConfig(ReporterConfiguration.class).isIncludeProcessArguments()) {
            processInformation.getArgv().clear();
        }
        ThreadPoolExecutor executor = ExecutorUtils.createThreadDaemonPool("metadata", 2, 3);
        final int metadataDiscoveryTimeoutMs = (int)coreConfiguration.getMetadataDiscoveryTimeoutMs();
        try {
            final Future<SystemInfo> systemInfoFuture = executor.submit(new Callable<SystemInfo>(){

                @Override
                public SystemInfo call() {
                    return SystemInfo.create(coreConfiguration.getHostname(), metadataDiscoveryTimeoutMs, serverlessConfiguration);
                }
            });
            final Future<CloudProviderInfo> cloudProviderInfoFuture = executor.submit(new Callable<CloudProviderInfo>(){

                @Override
                @Nullable
                public CloudProviderInfo call() {
                    return CloudMetadataProvider.getCloudInfoProvider(coreConfiguration.getCloudProvider(), metadataDiscoveryTimeoutMs, serverlessConfiguration);
                }
            });
            final CompletableFuture<FaaSMetaDataExtension> faaSMetaDataExtensionFuture = new CompletableFuture<FaaSMetaDataExtension>();
            if (!serverlessConfiguration.runsOnAwsLambda()) {
                faaSMetaDataExtensionFuture.complete(null);
            }
            Future<MetaData> metaDataFuture = executor.submit(new Callable<MetaData>(){

                @Override
                public MetaData call() throws Exception {
                    return new MetaData(processInformation, service, (SystemInfo)systemInfoFuture.get(), (CloudProviderInfo)cloudProviderInfoFuture.get(), coreConfiguration.getGlobalLabels(), (FaaSMetaDataExtension)faaSMetaDataExtensionFuture.get());
                }
            });
            MetaDataFuture metaDataFuture2 = new MetaDataFuture(metaDataFuture, faaSMetaDataExtensionFuture);
            return metaDataFuture2;
        }
        finally {
            executor.shutdown();
        }
    }

    public Service getService() {
        return this.service;
    }

    public ProcessInfo getProcess() {
        return this.process;
    }

    public SystemInfo getSystem() {
        return this.system;
    }

    public ArrayList<String> getGlobalLabelKeys() {
        return this.globalLabelKeys;
    }

    public ArrayList<String> getGlobalLabelValues() {
        return this.globalLabelValues;
    }

    @Nullable
    public CloudProviderInfo getCloudProviderInfo() {
        return this.cloudProviderInfo;
    }
}

