/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;

public class ServiceOrigin
implements Recyclable {
    @Nullable
    private String id;
    private final StringBuilder name = new StringBuilder();
    @Nullable
    private String version;

    @Nullable
    public String getId() {
        return this.id;
    }

    public ServiceOrigin withId(@Nullable String id) {
        this.id = id;
        return this;
    }

    public StringBuilder getName() {
        return this.name;
    }

    public ServiceOrigin withName(@Nullable CharSequence name) {
        this.name.setLength(0);
        if (name != null) {
            this.name.append(name);
        }
        return this;
    }

    public ServiceOrigin appendToName(@Nullable String namePart) {
        if (namePart != null) {
            this.name.append(namePart);
        }
        return this;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public ServiceOrigin withVersion(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Override
    public void resetState() {
        this.id = null;
        this.name.setLength(0);
        this.version = null;
    }

    public boolean hasContent() {
        return this.id != null || this.name.length() > 0 || this.version != null;
    }

    public void copyFrom(ServiceOrigin other) {
        this.id = other.id;
        this.withName(other.getName());
        this.version = other.version;
    }
}

