/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;

public class Http
implements Recyclable {
    private final Url url = new Url();
    @Nullable
    private String method;
    private int statusCode;

    public CharSequence getUrl() {
        return this.url.getFull();
    }

    public Url getInternalUrl() {
        return this.url;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Http withUrl(@Nullable String url) {
        if (url != null) {
            this.url.withFull(url);
        }
        return this;
    }

    public Http withMethod(String method) {
        this.method = method;
        return this;
    }

    public Http withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public void resetState() {
        this.url.resetState();
        this.method = null;
        this.statusCode = 0;
    }

    public boolean hasContent() {
        return this.url.hasContent() || this.method != null || this.statusCode > 0;
    }

    public void copyFrom(Http other) {
        this.url.copyFrom(other.url);
        this.method = other.method;
        this.statusCode = other.statusCode;
    }
}

