/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public class Destination
implements Recyclable {
    private final StringBuilder address = new StringBuilder();
    private boolean addressSetByUser;
    private int port;
    private boolean portSetByUser;
    private final Service service = new Service();

    public Destination withAddress(@Nullable CharSequence address) {
        if (address != null && !this.addressSetByUser) {
            this.withAddress(address, 0, address.length());
        }
        return this;
    }

    public Destination withUserAddress(@Nullable CharSequence address) {
        if (address == null || address.length() == 0) {
            this.address.setLength(0);
        } else {
            this.withAddress(address, 0, address.length());
        }
        this.addressSetByUser = true;
        return this;
    }

    public StringBuilder getAddress() {
        return this.address;
    }

    public Destination withPort(int port) {
        if (!this.portSetByUser) {
            this.port = port;
        }
        return this;
    }

    public Destination withUserPort(int port) {
        this.withPort(port);
        this.portSetByUser = true;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Destination withAddressPort(@Nullable String addressPort) {
        int port;
        int separator;
        if (addressPort != null && (separator = addressPort.lastIndexOf(58)) > 0 && (port = Destination.parsePort(addressPort, separator + 1, addressPort.length())) > 0) {
            this.withPort(port);
            if (!this.addressSetByUser) {
                this.withAddress(addressPort, 0, separator);
            }
        }
        return this;
    }

    private static int parsePort(CharSequence input, int start, int end) {
        int port = 0;
        for (int i = start; i < end; ++i) {
            char c = input.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            port += c - 48;
            if (i >= end - 1) continue;
            port *= 10;
        }
        return port;
    }

    private void withAddress(CharSequence address, int start, int end) {
        if (address.length() > 0 && start < end) {
            int startIndex = start;
            int endIndex = end - 1;
            if (address.charAt(startIndex) == '[') {
                ++startIndex;
            }
            if (address.charAt(endIndex) == ']') {
                --endIndex;
            }
            if (startIndex < endIndex) {
                if (this.address.length() > 0) {
                    this.address.delete(0, this.address.length());
                }
                this.address.append(address, startIndex, endIndex + 1);
            }
        }
    }

    public Service getService() {
        return this.service;
    }

    public boolean hasContent() {
        return this.address.length() > 0 || this.port > 0 || this.service.hasContent();
    }

    @Override
    public void resetState() {
        this.address.setLength(0);
        this.addressSetByUser = false;
        this.port = 0;
        this.portSetByUser = false;
        this.service.resetState();
    }

    public Destination withSocketAddress(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            this.withInetSocketAddress((InetSocketAddress)socketAddress);
        }
        return this;
    }

    public Destination withInetSocketAddress(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress != null) {
            this.withInetAddress(inetAddress);
        } else {
            this.withAddress(inetSocketAddress.getHostString());
        }
        this.withPort(inetSocketAddress.getPort());
        return this;
    }

    public Destination withInetAddress(InetAddress inetAddress) {
        this.withAddress(inetAddress.getHostAddress());
        return this;
    }

    public static class Service
    implements Recyclable {
        private final StringBuilder resource = new StringBuilder();
        private boolean resourceSetByUser;
        private final StringBuilder name = new StringBuilder();
        @Nullable
        private String type;

        public Service withUserResource(@Nullable String resource) {
            if (resource == null || resource.isEmpty()) {
                this.resource.setLength(0);
            } else {
                this.setResourceValue(resource);
            }
            this.resourceSetByUser = true;
            return this;
        }

        public Service withResource(String resource) {
            if (!this.resourceSetByUser) {
                this.setResourceValue(resource);
            }
            return this;
        }

        private void setResourceValue(String newValue) {
            this.resource.setLength(0);
            this.resource.append(newValue);
        }

        public boolean isResourceSetByUser() {
            return this.resourceSetByUser;
        }

        public StringBuilder getResource() {
            return this.resource;
        }

        @Deprecated
        public Service withName(String name) {
            return this;
        }

        @Deprecated
        public StringBuilder getName() {
            return this.name;
        }

        @Deprecated
        public Service withType(@Nullable String type) {
            return this;
        }

        @Nullable
        @Deprecated
        public String getType() {
            return this.type;
        }

        public boolean hasContent() {
            return this.resource.length() > 0;
        }

        @Override
        public void resetState() {
            this.resource.setLength(0);
            this.resourceSetByUser = false;
            this.name.setLength(0);
            this.type = null;
        }
    }
}

