/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.circuitbreaker;

import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import co.elastic.apm.agent.configuration.validation.RangeValidator;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;

public class CircuitBreakerConfiguration
extends ConfigurationOptionProvider {
    public static final String CIRCUIT_BREAKER_CATEGORY = "Circuit-Breaker";
    private final ConfigurationOption<Boolean> circuitBreakerEnabled = ConfigurationOption.booleanOption().key("circuit_breaker_enabled").tags("added[1.14.0]", "performance", "experimental").configurationCategory("Circuit-Breaker").description("A boolean specifying whether the circuit breaker should be enabled or not. \nWhen enabled, the agent periodically polls stress monitors to detect system/process/JVM stress state. \nIf ANY of the monitors detects a stress indication, the agent will become inactive, as if the \n<<config-recording,`recording`>> configuration option has been set to `false`, thus reducing resource consumption to a minimum. \nWhen inactive, the agent continues polling the same monitors in order to detect whether the stress state \nhas been relieved. If ALL monitors approve that the system/process/JVM is not under stress anymore, the \nagent will resume and become fully functional.").dynamic(true).buildWithDefault(false);
    private final ConfigurationOption<TimeDuration> stressMonitoringInterval = TimeDurationValueConverter.durationOption("s").key("stress_monitoring_interval").tags("added[1.14.0]").tags("performance").configurationCategory("Circuit-Breaker").description("The interval at which the agent polls the stress monitors. Must be at least `1s`.").addValidator(RangeValidator.isNotInRange(TimeDuration.of("0ms"), TimeDuration.of("999ms"))).dynamic(false).buildWithDefault(TimeDuration.of("5s"));
    private final ConfigurationOption<Double> gcStressThreshold = ConfigurationOption.doubleOption().key("stress_monitor_gc_stress_threshold").configurationCategory("Circuit-Breaker").tags("added[1.14.0]").tags("performance").description("The threshold used by the GC monitor to rely on for identifying heap stress.\nThe same threshold will be used for all heap pools, so that if ANY has a usage percentage that crosses it, \nthe agent will consider it as a heap stress. The GC monitor relies only on memory consumption measured \nafter a recent GC.").dynamic(true).addValidator(RangeValidator.isInRange(0.0, 1.0)).buildWithDefault(0.95);
    private final ConfigurationOption<Double> gcReliefThreshold = ConfigurationOption.doubleOption().key("stress_monitor_gc_relief_threshold").configurationCategory("Circuit-Breaker").tags("added[1.14.0]").tags("performance").description("The threshold used by the GC monitor to rely on for identifying when the heap is not under stress .\nIf `stress_monitor_gc_stress_threshold` has been crossed, the agent will consider it a heap-stress state. \nIn order to determine that the stress state is over, percentage of occupied memory in ALL heap pools should \nbe lower than this threshold. The GC monitor relies only on memory consumption measured after a recent GC.").dynamic(true).addValidator(RangeValidator.isInRange(0.0, 1.0)).buildWithDefault(0.75);
    private final ConfigurationOption<TimeDuration> cpuStressDurationThreshold = TimeDurationValueConverter.durationOption("m").key("stress_monitor_cpu_duration_threshold").configurationCategory("Circuit-Breaker").tags("added[1.14.0]").tags("performance").description("The minimal time required in order to determine whether the system is \neither currently under stress, or that the stress detected previously has been relieved. \nAll measurements during this time must be consistent in comparison to the relevant threshold in \norder to detect a change of stress state. Must be at least `1m`.").addValidator(RangeValidator.isNotInRange(TimeDuration.of("0ms"), TimeDuration.of("59s"))).dynamic(true).buildWithDefault(TimeDuration.of("1m"));
    private final ConfigurationOption<Double> systemCpuStressThreshold = ConfigurationOption.doubleOption().key("stress_monitor_system_cpu_stress_threshold").configurationCategory("Circuit-Breaker").tags("added[1.14.0]").tags("performance").description("The threshold used by the system CPU monitor to detect system CPU stress. \nIf the system CPU crosses this threshold for a duration of at least `stress_monitor_cpu_duration_threshold`, \nthe monitor considers this as a stress state.").dynamic(true).addValidator(RangeValidator.isInRange(0.0, 1.0)).buildWithDefault(0.95);
    private final ConfigurationOption<Double> systemCpuReliefThreshold = ConfigurationOption.doubleOption().key("stress_monitor_system_cpu_relief_threshold").configurationCategory("Circuit-Breaker").tags("added[1.14.0]").tags("performance").description("The threshold used by the system CPU monitor to determine that the system is \nnot under CPU stress. If the monitor detected a CPU stress, the measured system CPU needs to be below \nthis threshold for a duration of at least `stress_monitor_cpu_duration_threshold` in order for the \nmonitor to decide that the CPU stress has been relieved.").dynamic(true).addValidator(RangeValidator.isInRange(0.0, 1.0)).buildWithDefault(0.8);

    public boolean isCircuitBreakerEnabled() {
        return this.circuitBreakerEnabled.get();
    }

    public long getStressMonitoringPollingIntervalMillis() {
        return this.stressMonitoringInterval.get().getMillis();
    }

    public double getGcStressThreshold() {
        return this.gcStressThreshold.get();
    }

    public double getGcReliefThreshold() {
        return this.gcReliefThreshold.get();
    }

    public long getCpuStressDurationThresholdMillis() {
        return this.cpuStressDurationThreshold.get().getMillis();
    }

    public double getSystemCpuStressThreshold() {
        return this.systemCpuStressThreshold.get();
    }

    public double getSystemCpuReliefThreshold() {
        return this.systemCpuReliefThreshold.get();
    }
}

