/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.GrpcHelper;
import co.elastic.apm.agent.impl.transaction.Transaction;
import io.grpc.ServerCall;
import io.grpc.Status;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ServerCallListenerInstrumentation
extends BaseInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.any();
    }

    public static class OnComplete
    extends ServerCallListenerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onComplete");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ServerCallListenerInstrumentation$OnComplete$OnCompleteAdvice";
        }

        public static class OnCompleteAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ServerCall.Listener<?> listener) {
                return GrpcHelper.getInstance().enterServerListenerMethod(listener);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.This ServerCall.Listener<?> listener, @Advice.Enter @Nullable Object transaction) {
                if (transaction instanceof Transaction) {
                    GrpcHelper.getInstance().exitServerListenerMethod(thrown, listener, (Transaction)transaction, Status.OK);
                }
            }
        }
    }

    public static class OnCancel
    extends ServerCallListenerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onCancel");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ServerCallListenerInstrumentation$OnCancel$OnCancelAdvice";
        }

        public static class OnCancelAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ServerCall.Listener<?> listener) {
                return GrpcHelper.getInstance().enterServerListenerMethod(listener);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.This ServerCall.Listener<?> listener, @Advice.Enter @Nullable Object transaction) {
                if (transaction instanceof Transaction) {
                    GrpcHelper.getInstance().exitServerListenerMethod(thrown, listener, (Transaction)transaction, Status.CANCELLED);
                }
            }
        }
    }

    public static class OtherMethod
    extends ServerCallListenerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onReady").or(ElementMatchers.named("onMessage")).or(ElementMatchers.named("onHalfClose"));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ServerCallListenerInstrumentation$OtherMethod$OtherMethodAdvice";
        }

        public static class OtherMethodAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ServerCall.Listener<?> listener) {
                return GrpcHelper.getInstance().enterServerListenerMethod(listener);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.This ServerCall.Listener<?> listener, @Advice.Enter @Nullable Object transaction) {
                if (transaction instanceof Transaction) {
                    GrpcHelper.getInstance().exitServerListenerMethod(thrown, listener, (Transaction)transaction, null);
                }
            }
        }
    }
}

