/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.ClientCallImplInstrumentation;
import co.elastic.apm.agent.grpc.GrpcHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ChannelInstrumentation
extends BaseInstrumentation {
    private static final Collection<Class<? extends ElasticApmInstrumentation>> CLIENT_CALL_INSTRUMENTATION = Arrays.asList(ClientCallImplInstrumentation.Start.class, ClientCallImplInstrumentation.Cancel.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc").and(ElementMatchers.nameContains("Channel"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.Channel").and(ElementMatchers.not(ElementMatchers.named("io.grpc.internal.ForwardingManagedChannel"))));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("newCall");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.grpc.ChannelInstrumentation$ChannelAdvice";
    }

    public static class ChannelAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.This Channel channel, @Advice.Argument(value=0) MethodDescriptor<?, ?> method) {
            return GrpcHelper.getInstance().onClientCallCreationEntry(TracerAwareInstrumentation.tracer.getActive(), method, channel.authority());
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Return @Nullable ClientCall<?, ?> clientCall, @Advice.Enter @Nullable Object span) {
            if (clientCall != null) {
                DynamicTransformer.ensureInstrumented(clientCall.getClass(), CLIENT_CALL_INSTRUMENTATION);
            }
            GrpcHelper.getInstance().onClientCallCreationExit(clientCall, (Span)span);
        }
    }
}

