/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grails;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.TransactionNameUtils;
import grails.core.GrailsControllerClass;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.grails.web.mapping.mvc.GrailsControllerUrlMappingInfo;

public class GrailsTransactionNameInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("org.grails.web.mapping.mvc").and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.HandlerAdapter"))).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, Object.class));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("org.grails.web.mapping.mvc.GrailsControllerUrlMappingInfo");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.grails.GrailsTransactionNameInstrumentation$HandlerAdapterAdvice";
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("grails");
    }

    public static class HandlerAdapterAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void setTransactionName(@Advice.Argument(value=2) Object handler) {
            String methodName;
            String className;
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction == null) {
                return;
            }
            if (handler instanceof GrailsControllerUrlMappingInfo) {
                GrailsControllerUrlMappingInfo urlMappingInfo = (GrailsControllerUrlMappingInfo)handler;
                GrailsControllerClass grailsControllerClass = urlMappingInfo.getControllerClass();
                className = grailsControllerClass.getShortName();
                String actionName = urlMappingInfo.getActionName();
                methodName = actionName != null ? actionName : "index";
            } else {
                className = handler.getClass().getSimpleName();
                methodName = null;
            }
            TransactionNameUtils.setNameFromClassAndMethod(className, methodName, transaction.getAndOverrideName(100));
        }
    }
}

