/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

public class DubboTraceHelper {
    private static final String EXTERNAL_TYPE = "external";
    private static final String DUBBO_SUBTYPE = "dubbo";
    public static final String SPAN_KEY = "_elastic_apm_span";

    @Nullable
    public static Span createConsumerSpan(ElasticApmTracer tracer, Class<?> apiClass, String methodName, InetSocketAddress remoteAddress) {
        AbstractSpan<?> traceContext = tracer.getActive();
        if (traceContext == null) {
            return null;
        }
        Span span = traceContext.createExitSpan();
        if (span == null) {
            return null;
        }
        span.withType(EXTERNAL_TYPE).withSubtype(DUBBO_SUBTYPE);
        span.updateName(apiClass, methodName);
        Destination destination = span.getContext().getDestination();
        destination.withInetSocketAddress(remoteAddress);
        Destination.Service service = destination.getService();
        service.withType(EXTERNAL_TYPE).withName(DUBBO_SUBTYPE);
        service.getResource().append(remoteAddress.getHostName()).append(':').append(remoteAddress.getPort());
        return (Span)span.activate();
    }

    public static void fillTransaction(Transaction transaction, Class<?> apiClass, String methodName) {
        transaction.updateName(apiClass, methodName);
        transaction.withType("request");
    }
}

