/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo.advice;

import co.elastic.apm.agent.dubbo.helper.ApacheDubboTextMapPropagator;
import co.elastic.apm.agent.dubbo.helper.DubboTraceHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;

public class ApacheMonitorFilterAdvice {
    private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object onEnterFilterInvoke(@Advice.Argument(value=1) Invocation invocation) {
        Transaction transaction;
        RpcContext context = RpcContext.getContext();
        AbstractSpan<?> active = tracer.getActive();
        if (context.isConsumerSide() && active != null) {
            Span span = DubboTraceHelper.createConsumerSpan(tracer, invocation.getInvoker().getInterface(), invocation.getMethodName(), context.getRemoteAddress());
            if (span != null) {
                span.propagateTraceContext(invocation, ApacheDubboTextMapPropagator.INSTANCE);
                return span;
            }
        } else if (active == null && (transaction = tracer.startChildTransaction(invocation, ApacheDubboTextMapPropagator.INSTANCE, Invocation.class.getClassLoader())) != null) {
            transaction.activate();
            DubboTraceHelper.fillTransaction(transaction, invocation.getInvoker().getInterface(), invocation.getMethodName());
            return transaction;
        }
        return null;
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void onExitFilterInvoke(@Advice.Argument(value=1) Invocation invocation, @Advice.Return @Nullable Result result, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
        AbstractSpan span = (AbstractSpan)spanObj;
        RpcContext context = RpcContext.getContext();
        if (span == null) {
            return;
        }
        span.deactivate();
        if (result instanceof AsyncRpcResult) {
            context.set("_elastic_apm_span", (Object)span);
            result.whenCompleteWithContext(AsyncCallback.INSTANCE);
        } else {
            span.end();
        }
    }

    public static class AsyncCallback
    implements BiConsumer<Result, Throwable> {
        private static final BiConsumer<Result, Throwable> INSTANCE = new AsyncCallback();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@Nullable Result result, @Nullable Throwable t) {
            AbstractSpan span = (AbstractSpan)RpcContext.getContext().get("_elastic_apm_span");
            if (span != null) {
                try {
                    RpcContext.getContext().remove("_elastic_apm_span");
                    Throwable resultException = null;
                    if (result != null) {
                        resultException = result.getException();
                    }
                    ((AbstractSpan)((AbstractSpan)span.captureException(t)).captureException(resultException)).withOutcome(t != null || resultException != null ? Outcome.FAILURE : Outcome.SUCCESS);
                }
                finally {
                    span.end();
                }
            }
        }
    }
}

