/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo;

import co.elastic.apm.agent.dubbo.AbstractAlibabaDubboInstrumentation;
import co.elastic.apm.agent.dubbo.AlibabaCallbackHolder;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.rpc.Result;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class AlibabaResponseCallbackInstrumentation
extends AbstractAlibabaDubboInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseCallback"));
    }

    public static class CaughtInstrumentation
    extends AlibabaResponseCallbackInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("caught").and(ElementMatchers.isOverriddenFrom(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseCallback")));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ResponseCallback thiz) {
                AbstractSpan<?> span = AlibabaCallbackHolder.callbackSpanMap.remove(thiz);
                if (span != null) {
                    span.activate();
                }
                return span;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.Enter @Nullable Object spanObj, @Advice.Argument(value=0) @Nullable Throwable caught) {
                AbstractSpan span = (AbstractSpan)spanObj;
                if (span == null) {
                    return;
                }
                ((AbstractSpan)((AbstractSpan)((AbstractSpan)((AbstractSpan)span.captureException(thrown)).captureException(caught)).withOutcome(caught != null || thrown != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }
    }

    public static class DoneInstrumentation
    extends AlibabaResponseCallbackInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("done").and(ElementMatchers.isOverriddenFrom(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseCallback")));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ResponseCallback thiz) {
                AbstractSpan<?> span = AlibabaCallbackHolder.callbackSpanMap.remove(thiz);
                if (span != null) {
                    span.activate();
                }
                return span;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.Enter @Nullable Object spanObj, @Advice.Argument(value=0) @Nullable Object response) {
                AbstractSpan span = (AbstractSpan)spanObj;
                if (span == null) {
                    return;
                }
                Throwable resultException = null;
                if (response instanceof Result) {
                    resultException = ((Result)response).getException();
                }
                ((AbstractSpan)((AbstractSpan)((AbstractSpan)((AbstractSpan)span.captureException(thrown)).captureException(resultException)).withOutcome(thrown != null || resultException != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }
    }
}

