/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.source;

import co.elastic.apm.agent.configuration.source.ConfigSources;
import java.util.Properties;
import org.stagemonitor.configuration.source.AbstractConfigurationSource;

public final class PropertyFileConfigurationSource
extends AbstractConfigurationSource {
    private final String location;
    private Properties properties;

    PropertyFileConfigurationSource(String location, Properties properties) {
        this.location = location;
        this.properties = properties;
    }

    @Override
    public void reload() {
        if (this.location == null) {
            return;
        }
        Properties newProperties = ConfigSources.getPropertiesFromFilesystem(this.location);
        if (newProperties != null) {
            this.properties = newProperties;
        }
    }

    @Override
    public String getName() {
        return this.location;
    }

    @Override
    public String getValue(String key) {
        return this.properties.getProperty(key);
    }
}

