/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;

public class ServerlessConfiguration
extends ConfigurationOptionProvider {
    public static final String SERVERLESS_CATEGORY = "Serverless";
    private final ConfigurationOption<String> awsLambdaHandler = ConfigurationOption.stringOption().key("aws_lambda_handler").tags("added[1.28.0]").configurationCategory("Serverless").description("This config option must be used when running the agent in an AWS Lambda context. \nThis config value allows to specify the fully qualified name of the class handling the lambda function. \nAn empty value (default value) indicates that the agent is not running within an AWS lambda function.").buildWithDefault("");
    private final ConfigurationOption<Long> dataFlushTimeout = ConfigurationOption.longOption().key("data_flush_timeout").tags("added[1.28.0]").configurationCategory("Serverless").description("This config value allows to specify the timeout in milliseconds for flushing APM data at the end of a serverless function. \nFor serverless functions, APM data is written in a synchronous way, thus, blocking the termination of the function util data is written or the specified timeout is reached.").buildWithDefault(1000L);

    public String getAwsLambdaHandler() {
        return this.awsLambdaHandler.get();
    }

    public long getDataFlushTimeout() {
        return this.dataFlushTimeout.get();
    }

    public boolean runsOnAwsLambda() {
        String lambdaName = System.getenv("AWS_LAMBDA_FUNCTION_NAME");
        return null != lambdaName && !lambdaName.isEmpty();
    }
}

