/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.collections.CachedKeyWeakConcurrentMap;
import co.elastic.apm.agent.collections.NullCheck;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import com.blogspot.mydailyjava.weaklockfree.AbstractWeakConcurrentMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class NullSafeWeakConcurrentMap<K, V>
extends CachedKeyWeakConcurrentMap<K, V> {
    private final WeakMap.DefaultValueSupplier<K, V> defaultValueSupplier;

    NullSafeWeakConcurrentMap(ConcurrentMap<AbstractWeakConcurrentMap.WeakKey<K>, V> target) {
        this(target, new NullValueSupplier());
    }

    NullSafeWeakConcurrentMap(ConcurrentMap<AbstractWeakConcurrentMap.WeakKey<K>, V> target, @Nullable WeakMap.DefaultValueSupplier<K, V> defaultValueSupplier) {
        super(target);
        this.defaultValueSupplier = defaultValueSupplier != null ? defaultValueSupplier : new NullValueSupplier();
    }

    @Override
    @Nullable
    public V get(K key) {
        if (NullCheck.isNullKey(key)) {
            return null;
        }
        return super.get(key);
    }

    @Override
    @Nullable
    public V getIfPresent(K key) {
        if (NullCheck.isNullKey(key)) {
            return null;
        }
        return super.getIfPresent(key);
    }

    @Override
    public boolean containsKey(K key) {
        if (NullCheck.isNullKey(key)) {
            return false;
        }
        return super.containsKey(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        if (NullCheck.isNullKey(key) || NullCheck.isNullValue(value)) {
            return null;
        }
        return super.put(key, value);
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        if (NullCheck.isNullKey(key) || NullCheck.isNullValue(value)) {
            return null;
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    @Nullable
    public V putIfProbablyAbsent(K key, V value) {
        if (NullCheck.isNullKey(key) || NullCheck.isNullValue(value)) {
            return null;
        }
        return super.putIfProbablyAbsent(key, value);
    }

    @Override
    @Nullable
    public V remove(K key) {
        if (NullCheck.isNullKey(key)) {
            return null;
        }
        return super.remove(key);
    }

    @Override
    @Nullable
    protected V defaultValue(K key) {
        return this.defaultValueSupplier.getDefaultValue(key);
    }

    private static class NullValueSupplier<K, V>
    implements WeakMap.DefaultValueSupplier<K, V> {
        private NullValueSupplier() {
        }

        @Override
        @Nullable
        public V getDefaultValue(K key) {
            return null;
        }
    }
}

