/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodHierarchyMatcher
extends ElementMatcher.Junction.AbstractBase<MethodDescription> {
    private final ElementMatcher<? super MethodDescription> extraMethodMatcher;
    private final ElementMatcher<? super TypeDescription> superClassMatcher;

    MethodHierarchyMatcher(ElementMatcher<? super MethodDescription> extraMethodMatcher) {
        this(extraMethodMatcher, ElementMatchers.not(ElementMatchers.is(TypeDescription.ForLoadedType.OBJECT)));
    }

    private MethodHierarchyMatcher(ElementMatcher<? super MethodDescription> extraMethodMatcher, ElementMatcher<? super TypeDescription> superClassMatcher) {
        this.extraMethodMatcher = extraMethodMatcher;
        this.superClassMatcher = superClassMatcher;
    }

    public ElementMatcher<MethodDescription> onSuperClassesThat(ElementMatcher<? super TypeDescription> superClassMatcher) {
        return new MethodHierarchyMatcher(this.extraMethodMatcher, superClassMatcher);
    }

    @Override
    public boolean matches(MethodDescription targetMethod) {
        return this.declaresInHierarchy(targetMethod, targetMethod.getDeclaringType().asErasure());
    }

    private boolean declaresInHierarchy(MethodDescription targetMethod, TypeDescription type) {
        if (ElementMatchers.declaresMethod(ElementMatchers.named(targetMethod.getName()).and(ElementMatchers.returns(targetMethod.getReturnType().asErasure())).and(ElementMatchers.takesArguments(targetMethod.getParameters().asTypeList().asErasures())).and(this.extraMethodMatcher)).matches(type)) {
            return true;
        }
        for (TypeDescription interfaze : type.getInterfaces().asErasures()) {
            if (!this.superClassMatcher.matches(interfaze) || !this.declaresInHierarchy(targetMethod, interfaze)) continue;
            return true;
        }
        TypeDescription.Generic superClass = type.getSuperClass();
        if (superClass != null && this.superClassMatcher.matches(superClass.asErasure())) {
            return this.declaresInHierarchy(targetMethod, superClass.asErasure());
        }
        return false;
    }
}

