/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.metadata.FaaSMetaDataExtension;
import co.elastic.apm.agent.impl.metadata.Framework;
import co.elastic.apm.agent.impl.metadata.NameAndIdField;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.VersionUtils;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLambdaTransactionHelper<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLambdaTransactionHelper.class);
    protected final ElasticApmTracer tracer;
    protected final ServerlessConfiguration serverlessConfiguration;
    protected final CoreConfiguration coreConfiguration;
    protected final WebConfiguration webConfiguration;
    private static boolean coldStart = true;

    protected AbstractLambdaTransactionHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
        this.serverlessConfiguration = tracer.getConfig(ServerlessConfiguration.class);
    }

    protected abstract void setTransactionTriggerData(Transaction var1, I var2);

    @Nullable
    protected abstract Transaction doStartTransaction(I var1, Context var2);

    protected abstract void captureOutputForTransaction(Transaction var1, O var2);

    @Nullable
    public Transaction startTransaction(I input, Context lambdaContext) {
        Transaction transaction;
        boolean isColdStart = coldStart;
        if (isColdStart) {
            this.completeMetaData(lambdaContext);
            coldStart = false;
        }
        if (null != (transaction = this.doStartTransaction(input, lambdaContext))) {
            transaction.getFaas().withColdStart(isColdStart).withExecution(lambdaContext.getAwsRequestId());
            transaction.getContext().getCloudOrigin().withProvider("aws");
            this.setTransactionName(transaction, input, lambdaContext);
            this.setTransactionTriggerData(transaction, input);
            return (Transaction)transaction.activate();
        }
        return null;
    }

    public void finalizeTransaction(Transaction transaction, @Nullable O output, @Nullable Throwable thrown) {
        if (null != output) {
            this.captureOutputForTransaction(transaction, output);
        }
        if (thrown != null) {
            transaction.captureException(thrown);
            transaction.withResultIfUnset("failure");
        } else {
            transaction.withResultIfUnset("success");
        }
        ((Transaction)transaction.deactivate()).end();
        long flushTimeout = this.serverlessConfiguration.getDataFlushTimeout();
        try {
            if (!this.tracer.getReporter().flush(flushTimeout, TimeUnit.MILLISECONDS)) {
                logger.error("APM data flush haven't completed within {} milliseconds.", (Object)flushTimeout);
            }
        }
        catch (Exception e) {
            logger.error("An error occurred on flushing APM data.", e);
        }
    }

    private void completeMetaData(Context lambdaContext) {
        try {
            String lambdaLibVersion;
            String functionArn = lambdaContext.getInvokedFunctionArn();
            String[] arnSegments = functionArn.split(":");
            String region = arnSegments[3];
            String accountId = arnSegments[4];
            if (arnSegments.length > 6) {
                functionArn = functionArn.substring(0, functionArn.lastIndexOf(58));
            }
            if ((lambdaLibVersion = VersionUtils.getVersion(RequestHandler.class, "com.amazonaws", "aws-lambda-java-core")) == null) {
                lambdaLibVersion = "unknown";
            }
            this.tracer.getMetaDataFuture().getFaaSMetaDataExtensionFuture().complete(new FaaSMetaDataExtension(new Framework("AWS Lambda", lambdaLibVersion), functionArn, new NameAndIdField(null, accountId), region));
        }
        catch (Exception e) {
            logger.error("Failed updating metadata for first lambda execution!", e);
        }
    }

    protected void setTransactionName(Transaction transaction, I event, Context lambdaContext) {
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        if (transactionName != null) {
            transactionName.append(lambdaContext.getFunctionName());
        }
    }
}

