/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda;

import co.elastic.apm.agent.awslambda.AbstractAwsLambdaHandlerInstrumentation;
import co.elastic.apm.agent.awslambda.helper.APIGatewayProxyV1TransactionHelper;
import co.elastic.apm.agent.awslambda.helper.APIGatewayProxyV2TransactionHelper;
import co.elastic.apm.agent.awslambda.helper.PlainTransactionHelper;
import co.elastic.apm.agent.awslambda.helper.S3TransactionHelper;
import co.elastic.apm.agent.awslambda.helper.SNSTransactionHelper;
import co.elastic.apm.agent.awslambda.helper.SQSTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class RequestHandlerInstrumentation
extends AbstractAwsLambdaHandlerInstrumentation {
    public RequestHandlerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        String matchMethod = this.handlerMethodName != null ? this.handlerMethodName : "handleRequest";
        return ElementMatchers.isPublic().and(ElementMatchers.named(matchMethod)).and(ElementMatchers.takesArgument(1, ElementMatchers.named("com.amazonaws.services.lambda.runtime.Context")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.awslambda.RequestHandlerInstrumentation$RequestHandlerAdvice";
    }

    public static class RequestHandlerAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object handlerEnter(@Advice.Argument(value=0) Object input, @Advice.Argument(value=1) Context lambdaContext) {
            if (input instanceof APIGatewayV2HTTPEvent) {
                return APIGatewayProxyV2TransactionHelper.getInstance().startTransaction((APIGatewayV2HTTPEvent)input, lambdaContext);
            }
            if (input instanceof APIGatewayProxyRequestEvent) {
                return APIGatewayProxyV1TransactionHelper.getInstance().startTransaction((APIGatewayProxyRequestEvent)input, lambdaContext);
            }
            if (input instanceof SQSEvent) {
                return SQSTransactionHelper.getInstance().startTransaction((SQSEvent)input, lambdaContext);
            }
            if (input instanceof SNSEvent) {
                return SNSTransactionHelper.getInstance().startTransaction((SNSEvent)input, lambdaContext);
            }
            if (input instanceof S3Event) {
                return S3TransactionHelper.getInstance().startTransaction((S3Event)input, lambdaContext);
            }
            return PlainTransactionHelper.getInstance().startTransaction(input, lambdaContext);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void handlerExit(@Nullable @Advice.Enter Object transactionObj, @Nullable @Advice.Thrown Throwable thrown, @Nullable @Advice.Return Object output) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                if (output instanceof APIGatewayV2HTTPResponse) {
                    APIGatewayProxyV2TransactionHelper.getInstance().finalizeTransaction(transaction, (APIGatewayV2HTTPResponse)output, thrown);
                } else if (output instanceof APIGatewayProxyResponseEvent) {
                    APIGatewayProxyV1TransactionHelper.getInstance().finalizeTransaction(transaction, (APIGatewayProxyResponseEvent)output, thrown);
                } else {
                    PlainTransactionHelper.getInstance().finalizeTransaction(transaction, output, thrown);
                }
            }
        }
    }
}

