/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.state;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CallDepth {
    private static final ConcurrentMap<String, CallDepth> registry = new ConcurrentHashMap<String, CallDepth>();
    private final ThreadLocal<Integer> callDepthPerThread = new ThreadLocal();

    private CallDepth() {
    }

    public static CallDepth get(Class<?> adviceClass) {
        String key = adviceClass.getName();
        return CallDepth.get(key);
    }

    public static CallDepth get(String key) {
        CallDepth callDepth = (CallDepth)registry.get(key);
        if (callDepth == null) {
            registry.putIfAbsent(key, new CallDepth());
            callDepth = (CallDepth)registry.get(key);
        }
        return callDepth;
    }

    static void clearRegistry() {
        registry.clear();
    }

    public int increment() {
        int depth = this.get();
        this.set(depth + 1);
        return depth;
    }

    public boolean isNestedCallAndIncrement() {
        return this.increment() != 0;
    }

    public int decrement() {
        int depth = this.get() - 1;
        this.set(depth);
        assert (depth >= 0);
        return depth;
    }

    public boolean isNestedCallAndDecrement() {
        return this.decrement() != 0;
    }

    public int get() {
        Integer callDepthForCurrentThread = this.callDepthPerThread.get();
        if (callDepthForCurrentThread == null) {
            callDepthForCurrentThread = 0;
            this.callDepthPerThread.set(callDepthForCurrentThread);
        }
        return callDepthForCurrentThread;
    }

    private void set(int depth) {
        this.callDepthPerThread.set(depth);
    }
}

