/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.bytebuddy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Version
implements Comparable<Version> {
    private static final Version INVALID = new Version(new int[0]);
    private static final Pattern VERSION_REGEX = Pattern.compile("^(?<prefix>.*?)(?<version>(\\d+)(\\.\\d+)*)(?<suffix>.*?)$");
    private final int[] numbers;

    static Version of(String version) {
        Matcher matcher = VERSION_REGEX.matcher(version);
        if (!matcher.find()) {
            return INVALID;
        }
        String[] parts = matcher.group("version").split("\\.");
        int[] numbers = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            numbers[i] = Integer.parseInt(parts[i]);
        }
        return new Version(numbers);
    }

    private Version(int[] numbers) {
        this.numbers = numbers;
    }

    @Override
    public int compareTo(Version another) {
        int maxLength = Math.max(this.numbers.length, another.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int right;
            int left = i < this.numbers.length ? this.numbers[i] : 0;
            int n = right = i < another.numbers.length ? another.numbers[i] : 0;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        return 0;
    }
}

