/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.bytebuddy;

import co.elastic.apm.agent.sdk.bytebuddy.MethodHierarchyMatcher;
import co.elastic.apm.agent.sdk.bytebuddy.Version;
import co.elastic.apm.agent.sdk.internal.InternalUtil;
import co.elastic.apm.agent.sdk.internal.util.PrivilegedActionUtils;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class CustomElementMatchers {
    private static final Logger logger = LoggerFactory.getLogger(CustomElementMatchers.class);
    @Nullable
    private static final ClassLoader SELF_CLASS_LOADER = PrivilegedActionUtils.getClassLoader(CustomElementMatchers.class);
    private static final CustomElementMatchersProvider supplier = InternalUtil.getServiceProvider(CustomElementMatchersProvider.class);
    private static final ElementMatcher.Junction.AbstractBase<ClassLoader> AGENT_CLASS_LOADER_MATCHER = new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

        public boolean matches(@Nullable ClassLoader classLoader) {
            if (classLoader == SELF_CLASS_LOADER) {
                return true;
            }
            return supplier.isAgentClassLoader(classLoader);
        }
    };
    private static final ElementMatcher.Junction.AbstractBase<ClassLoader> INTERNAL_PLUGIN_CLASS_LOADER_MATCHER = new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

        public boolean matches(@Nullable ClassLoader classLoader) {
            return supplier.isInternalPluginClassLoader(classLoader);
        }
    };

    public static ElementMatcher.Junction<ClassLoader> isSameClassLoader(final ClassLoader other) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

            public boolean matches(@Nullable ClassLoader target) {
                return target == other;
            }
        };
    }

    public static ElementMatcher.Junction<ClassLoader> isAgentClassLoader() {
        return AGENT_CLASS_LOADER_MATCHER;
    }

    public static ElementMatcher.Junction<ClassLoader> isInternalPluginClassLoader() {
        return INTERNAL_PLUGIN_CLASS_LOADER_MATCHER;
    }

    public static ElementMatcher.Junction<NamedElement> isInAnyPackage(Collection<String> includedPackages, ElementMatcher.Junction<NamedElement> defaultIfEmpty) {
        if (includedPackages.isEmpty()) {
            return defaultIfEmpty;
        }
        ElementMatcher.Junction matcher = ElementMatchers.none();
        for (String applicationPackage : includedPackages) {
            matcher = matcher.or((ElementMatcher)ElementMatchers.nameStartsWith((String)applicationPackage));
        }
        return matcher;
    }

    public static ElementMatcher.Junction<ClassLoader> classLoaderCanLoadClass(final String className) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){
            private final boolean loadableByBootstrapClassLoader;
            private final WeakMap<ClassLoader, Boolean> cache;
            {
                this.loadableByBootstrapClassLoader = CustomElementMatchers.canLoadClass(null, className);
                this.cache = WeakConcurrent.buildMap();
            }

            public boolean matches(@Nullable ClassLoader target) {
                if (target == null) {
                    return this.loadableByBootstrapClassLoader;
                }
                Boolean result = this.cache.get(target);
                if (result == null) {
                    result = CustomElementMatchers.canLoadClass(target, className);
                    this.cache.put(target, result);
                }
                return result;
            }
        };
    }

    private static boolean canLoadClass(@Nullable ClassLoader target, String className) {
        try {
            String classResource = className.replace('.', '/') + ".class";
            URL resource = target == null ? Object.class.getResource("/" + classResource) : target.getResource(classResource);
            return resource != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static MethodHierarchyMatcher overridesOrImplementsMethodThat(ElementMatcher<? super MethodDescription> methodElementMatcher) {
        return new MethodHierarchyMatcher(methodElementMatcher);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> isProxy() {
        return ElementMatchers.nameContains((String)"$Proxy").or((ElementMatcher)ElementMatchers.nameContains((String)"$$")).or((ElementMatcher)ElementMatchers.nameContains((String)"$JaxbAccessor")).or((ElementMatcher)ElementMatchers.nameContains((String)"CGLIB")).or((ElementMatcher)ElementMatchers.nameContains((String)"EnhancerBy"));
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionLte(String version) {
        return CustomElementMatchers.implementationVersion(version, Matcher.LTE, null, null);
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionGte(String version) {
        return CustomElementMatchers.implementationVersion(version, Matcher.GTE, null, null);
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionLte(String version, String groupId, String artifactId) {
        return CustomElementMatchers.implementationVersion(version, Matcher.LTE, groupId, artifactId);
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionGte(String version, String groupId, String artifactId) {
        return CustomElementMatchers.implementationVersion(version, Matcher.GTE, groupId, artifactId);
    }

    private static ElementMatcher.Junction<ProtectionDomain> implementationVersion(final String version, final Matcher matcher, final @Nullable String mavenGroupId, final @Nullable String mavenArtifactId) {
        return new ElementMatcher.Junction.AbstractBase<ProtectionDomain>(){

            public boolean matches(@Nullable ProtectionDomain protectionDomain) {
                try {
                    Version pdVersion = CustomElementMatchers.readImplementationVersion(protectionDomain, mavenGroupId, mavenArtifactId);
                    if (pdVersion != null) {
                        Version limitVersion = Version.of(version);
                        return matcher.match(pdVersion, limitVersion);
                    }
                }
                catch (Exception e) {
                    logger.info("Cannot read implementation version based on ProtectionDomain. This should not affect your agent's functionality. Failed with message: " + e.getMessage());
                    logger.debug("Implementation version parsing error: " + protectionDomain, e);
                }
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Version readImplementationVersion(@Nullable ProtectionDomain protectionDomain, @Nullable String mavenGroupId, @Nullable String mavenArtifactId) throws IOException, URISyntaxException {
        Version version;
        block20: {
            version = null;
            ZipFile jarFile = null;
            if (protectionDomain == null) {
                logger.info("Cannot read implementation version - got null ProtectionDomain");
                return null;
            }
            try {
                Manifest manifest;
                ZipEntry zipEntry;
                URL jarUrl;
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource == null || (jarUrl = codeSource.getLocation()) == null) break block20;
                URLConnection urlConnection = jarUrl.openConnection();
                jarFile = urlConnection instanceof JarURLConnection ? ((JarURLConnection)urlConnection).getJarFile() : new JarFile(new File(jarUrl.toURI()));
                if (mavenGroupId != null && mavenArtifactId != null && (zipEntry = ((JarFile)jarFile).getEntry(String.format("META-INF/maven/%s/%s/pom.properties", mavenGroupId, mavenArtifactId))) != null) {
                    String stringVersion;
                    Properties properties = new Properties();
                    try (InputStream input = ((JarFile)jarFile).getInputStream(zipEntry);){
                        properties.load(input);
                    }
                    if (mavenGroupId.equals(properties.getProperty("groupId")) && mavenArtifactId.equals(properties.getProperty("artifactId")) && (stringVersion = properties.getProperty("version")) != null) {
                        version = Version.of(stringVersion);
                    }
                }
                if (version == null && (manifest = ((JarFile)jarFile).getManifest()) != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    String manifestVersion = attributes.getValue("Implementation-Version");
                    if (manifestVersion == null) {
                        manifestVersion = attributes.getValue("Bundle-Version");
                    }
                    if (manifestVersion != null) {
                        version = Version.of(manifestVersion);
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        logger.error("Error closing JarFile", e);
                    }
                }
            }
        }
        return version;
    }

    public static interface CustomElementMatchersProvider {
        public boolean isAgentClassLoader(@Nullable ClassLoader var1);

        public boolean isInternalPluginClassLoader(@Nullable ClassLoader var1);
    }

    private static enum Matcher {
        LTE{

            @Override
            <T extends Comparable<T>> boolean match(T c1, T c2) {
                return c1.compareTo(c2) <= 0;
            }
        }
        ,
        GTE{

            @Override
            <T extends Comparable<T>> boolean match(T c1, T c2) {
                return c1.compareTo(c2) >= 0;
            }
        };


        abstract <T extends Comparable<T>> boolean match(T var1, T var2);
    }
}

