/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.bytebuddy;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class SimpleMethodSignatureOffsetMappingFactory
implements Advice.OffsetMapping.Factory<SimpleMethodSignature> {
    public Class<SimpleMethodSignature> getAnnotationType() {
        return SimpleMethodSignature.class;
    }

    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<SimpleMethodSignature> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                String className = instrumentedMethod.getDeclaringType().getTypeName();
                String simpleClassName = className.substring(className.lastIndexOf(36) + 1);
                simpleClassName = simpleClassName.substring(simpleClassName.lastIndexOf(46) + 1);
                String signature = String.format("%s#%s", simpleClassName, instrumentedMethod.getName());
                return Advice.OffsetMapping.Target.ForStackManipulation.of((Object)signature);
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface SimpleMethodSignature {
    }
}

