/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.state;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GlobalVariables {
    private static final ConcurrentMap<String, Object> registry = new ConcurrentHashMap<String, Object>();

    public static <T> T get(Class<?> adviceClass, String key, T defaultValue) {
        key = adviceClass.getName() + "." + key;
        if (defaultValue.getClass().getClassLoader() != null && !defaultValue.getClass().getName().startsWith("co.elastic.apm.agent")) {
            throw new IllegalArgumentException("Registering types specific to an instrumentation plugin would lead to class loader leaks: " + defaultValue);
        }
        Object value = registry.get(key);
        if (value == null) {
            registry.putIfAbsent(key, defaultValue);
            value = registry.get(key);
        }
        return (T)value;
    }
}

