/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.weakmap;

import co.elastic.apm.agent.sdk.weakmap.NullSafeWeakConcurrentMap;
import co.elastic.apm.agent.sdk.weakmap.NullSafeWeakConcurrentSet;
import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentSet;

public class WeakMapSupplier {
    private static final WeakConcurrentSet<WeakConcurrentMap<?, ?>> registeredMaps = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.INLINE);
    private static final WeakConcurrentSet<WeakConcurrentSet<?>> registeredSets = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.INLINE);

    public static <K, V> WeakConcurrentMap<K, V> createMap() {
        NullSafeWeakConcurrentMap result = new NullSafeWeakConcurrentMap(false);
        WeakMapSupplier.registerMap(result);
        return result;
    }

    public static void registerMap(WeakConcurrentMap<?, ?> map) {
        registeredMaps.add(map);
    }

    public static <V> WeakConcurrentSet<V> createSet() {
        NullSafeWeakConcurrentSet weakSet = new NullSafeWeakConcurrentSet(WeakConcurrentSet.Cleaner.MANUAL);
        registeredSets.add(weakSet);
        return weakSet;
    }

    public static void expungeStaleEntries() {
        for (WeakConcurrentMap weakMap : registeredMaps) {
            weakMap.expungeStaleEntries();
        }
        for (WeakConcurrentSet weakSet : registeredSets) {
            weakSet.expungeStaleEntries();
        }
    }
}

