/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.state;

import co.elastic.apm.agent.sdk.weakmap.NullCheck;
import com.blogspot.mydailyjava.weaklockfree.DetachedThreadLocal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class GlobalThreadLocal<T>
extends DetachedThreadLocal<T> {
    private static final ConcurrentMap<String, GlobalThreadLocal<?>> registry = new ConcurrentHashMap();
    private final DefaultValueSupplier<T> defaultValueSupplier;

    private GlobalThreadLocal(@Nullable DefaultValueSupplier<T> defaultValueSupplier) {
        super(DetachedThreadLocal.Cleaner.INLINE);
        this.defaultValueSupplier = defaultValueSupplier != null ? defaultValueSupplier : new NullValueSupplier();
    }

    public static <T> GlobalThreadLocal<T> get(Class<?> adviceClass, String key) {
        return GlobalThreadLocal.get(adviceClass.getName() + "." + key, null);
    }

    public static <T> GlobalThreadLocal<T> get(Class<?> adviceClass, String key, @Nullable DefaultValueSupplier<T> defaultValueSupplier) {
        return GlobalThreadLocal.get(adviceClass.getName() + "." + key, defaultValueSupplier);
    }

    static <T> GlobalThreadLocal<T> get(String key, @Nullable DefaultValueSupplier<T> defaultValueSupplier) {
        GlobalThreadLocal threadLocal = (GlobalThreadLocal)((Object)registry.get(key));
        if (threadLocal == null) {
            registry.putIfAbsent(key, new GlobalThreadLocal<T>(defaultValueSupplier));
            threadLocal = (GlobalThreadLocal)((Object)registry.get(key));
        }
        return threadLocal;
    }

    @Nullable
    public T getAndRemove() {
        Object value = this.get();
        if (value != null) {
            this.clear();
        }
        return (T)value;
    }

    public T get(T defaultValue) {
        Object value = this.get();
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public void set(@Nullable T value) {
        if (NullCheck.isNullKey(value)) {
            return;
        }
        super.set(value);
    }

    @Nullable
    protected T initialValue(Thread thread) {
        return this.defaultValueSupplier.getDefaultValueForThread();
    }

    private class NullValueSupplier
    implements DefaultValueSupplier<T> {
        private NullValueSupplier() {
        }

        @Override
        @Nullable
        public T getDefaultValueForThread() {
            return null;
        }
    }

    public static interface DefaultValueSupplier<T> {
        @Nullable
        public T getDefaultValueForThread();
    }
}

