/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.state;

import com.blogspot.mydailyjava.weaklockfree.DetachedThreadLocal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class GlobalThreadLocal<T>
extends DetachedThreadLocal<T> {
    private static final ConcurrentMap<String, GlobalThreadLocal<?>> registry = new ConcurrentHashMap();
    @Nullable
    private final T defaultValue;

    private GlobalThreadLocal(@Nullable T defaultValue) {
        super(DetachedThreadLocal.Cleaner.INLINE);
        this.defaultValue = defaultValue;
    }

    public static <T> GlobalThreadLocal<T> get(Class<?> adviceClass, String key) {
        return GlobalThreadLocal.get(adviceClass.getName() + "." + key, null);
    }

    public static <T> GlobalThreadLocal<T> get(Class<?> adviceClass, String key, @Nullable T defaultValue) {
        return GlobalThreadLocal.get(adviceClass.getName() + "." + key, defaultValue);
    }

    private static <T> GlobalThreadLocal<T> get(String key, @Nullable T defaultValue) {
        GlobalThreadLocal threadLocal = (GlobalThreadLocal)((Object)registry.get(key));
        if (threadLocal == null) {
            registry.putIfAbsent(key, new GlobalThreadLocal<T>(defaultValue));
            threadLocal = (GlobalThreadLocal)((Object)registry.get(key));
        }
        return threadLocal;
    }

    @Nullable
    public T getAndRemove() {
        Object value = this.get();
        if (value != null) {
            this.clear();
        }
        return (T)value;
    }

    public T get(T defaultValue) {
        Object value = this.get();
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    @Nullable
    protected T initialValue(Thread thread) {
        return this.defaultValue;
    }
}

