/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.ElasticApmAttacher;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Nonnull;

public class RemoteAttacher {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Arguments arguments;
    private Set<JvmInfo> runningJvms = new HashSet<JvmInfo>();

    private RemoteAttacher(Arguments arguments) {
        this.arguments = arguments;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Arguments arguments;
        try {
            arguments = Arguments.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            arguments = Arguments.parse("--help");
        }
        RemoteAttacher attacher = new RemoteAttacher(arguments);
        if (arguments.isHelp()) {
            arguments.printHelp(System.out);
        } else if (arguments.isList()) {
            System.out.println(RemoteAttacher.getJpsOutput());
        } else if (arguments.getPid() != null) {
            RemoteAttacher.log("INFO", "Attaching the Elastic APM agent to %s", arguments.getPid());
            ElasticApmAttacher.attach(arguments.getPid(), arguments.getArgs());
            RemoteAttacher.log("INFO", "Done", new Object[0]);
        } else {
            do {
                attacher.attachToNewJvms(RemoteAttacher.getJpsOutput());
                Thread.sleep(1000L);
            } while (arguments.isContinuous());
        }
    }

    private static void log(String level, String message, Object ... args) {
        System.out.println(String.format("%s %5s ", df.format(new Date()), level) + String.format(message, args));
    }

    @Nonnull
    private static String getJpsOutput() throws IOException, InterruptedException {
        Process jps = new ProcessBuilder("jps", "-l").start();
        if (jps.waitFor() == 0) {
            return RemoteAttacher.toString(jps.getInputStream());
        }
        throw new IllegalStateException(RemoteAttacher.toString(jps.getErrorStream()));
    }

    private static String toString(InputStream inputStream) throws IOException {
        try {
            Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private void attachToNewJvms(String jpsOutput) {
        Set<JvmInfo> currentlyRunningJvms = this.getJVMs(jpsOutput);
        for (JvmInfo jvmInfo : this.getStartedJvms(currentlyRunningJvms)) {
            if (jvmInfo.packageOrPath.endsWith(".Jps") || jvmInfo.packageOrPath.isEmpty()) continue;
            this.onJvmStart(jvmInfo);
        }
        this.runningJvms = currentlyRunningJvms;
    }

    @Nonnull
    private Set<JvmInfo> getJVMs(String jpsOutput) {
        HashSet<JvmInfo> set = new HashSet<JvmInfo>();
        for (String s : jpsOutput.split("\n")) {
            JvmInfo parse = JvmInfo.parse(s);
            set.add(parse);
        }
        return set;
    }

    private Set<JvmInfo> getStartedJvms(Set<JvmInfo> currentlyRunningJvms) {
        HashSet<JvmInfo> newJvms = new HashSet<JvmInfo>(currentlyRunningJvms);
        newJvms.removeAll(this.runningJvms);
        return newJvms;
    }

    private void onJvmStart(JvmInfo jvmInfo) {
        if (this.isIncluded(jvmInfo) && !this.isExcluded(jvmInfo)) {
            try {
                String agentArgs = this.getAgentArgs(jvmInfo);
                RemoteAttacher.log("INFO", "Attaching the Elastic APM agent to %s with arguments %s", jvmInfo, agentArgs);
                ElasticApmAttacher.attach(jvmInfo.pid, agentArgs);
                RemoteAttacher.log("INFO", "Done", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            RemoteAttacher.log("DEBUG", "Not attaching the Elastic APM agent to %s, because it is not included or excluded.", jvmInfo);
        }
    }

    private String getAgentArgs(JvmInfo jvmInfo) throws IOException, InterruptedException {
        return this.arguments.getArgsProvider() != null ? this.getArgsProviderOutput(jvmInfo) : this.arguments.getArgs();
    }

    private String getArgsProviderOutput(JvmInfo jvmInfo) throws IOException, InterruptedException {
        Process jps = new ProcessBuilder(this.arguments.getArgsProvider(), jvmInfo.pid, jvmInfo.packageOrPath).start();
        if (jps.waitFor() == 0) {
            return RemoteAttacher.toString(jps.getInputStream());
        }
        RemoteAttacher.log("INFO", "Not attaching the Elastic APM agent to %s, because the '--args-provider %s' script ended with a non-zero status code.", jvmInfo, this.arguments.argsProvider);
        throw new IllegalStateException(RemoteAttacher.toString(jps.getErrorStream()));
    }

    private boolean isIncluded(JvmInfo jvmInfo) {
        if (this.arguments.getIncludes().isEmpty()) {
            return true;
        }
        for (String include : this.arguments.getIncludes()) {
            if (!jvmInfo.packageOrPath.matches(include)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(JvmInfo jvmInfo) {
        for (String exclude : this.arguments.getExcludes()) {
            if (!jvmInfo.packageOrPath.matches(exclude)) continue;
            return true;
        }
        return false;
    }

    static class Arguments {
        private final String pid;
        private final List<String> includes;
        private final List<String> excludes;
        private final String args;
        private final String argsProvider;
        private final boolean help;
        private final boolean list;
        private final boolean continuous;

        private Arguments(String pid, List<String> includes, List<String> excludes, String args, String argsProvider, boolean help, boolean list, boolean continuous) {
            this.help = help;
            this.list = list;
            this.continuous = continuous;
            if (args != null && argsProvider != null) {
                throw new IllegalArgumentException("Providing both --args and --args-provider is illegal");
            }
            if (!(pid == null || includes.isEmpty() && excludes.isEmpty() && !continuous)) {
                throw new IllegalArgumentException("Providing --pid and either of --include, --exclude or --continuous is illegal");
            }
            this.pid = pid;
            this.includes = includes;
            this.excludes = excludes;
            this.args = args;
            this.argsProvider = argsProvider;
        }

        static Arguments parse(String ... args) {
            String pid = null;
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList<String> excludes = new ArrayList<String>();
            String agentArgs = null;
            String argsProvider = null;
            boolean help = args.length == 0;
            boolean list = false;
            boolean continuous = false;
            String currentArg = "";
            block43: for (String arg : Arguments.normalize(args)) {
                if (arg.startsWith("-")) {
                    currentArg = arg;
                    switch (arg) {
                        case "-h": 
                        case "--help": {
                            help = true;
                            break;
                        }
                        case "-l": 
                        case "--list": {
                            list = true;
                            break;
                        }
                        case "-c": 
                        case "--continuous": {
                            continuous = true;
                            break;
                        }
                        case "-p": 
                        case "--pid": 
                        case "-a": 
                        case "--args": 
                        case "-A": 
                        case "--args-provider": 
                        case "-e": 
                        case "--exclude": 
                        case "-i": 
                        case "--include": {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal argument: " + arg);
                        }
                    }
                    continue;
                }
                switch (currentArg) {
                    case "-e": 
                    case "--exclude": {
                        excludes.add(arg);
                        continue block43;
                    }
                    case "-i": 
                    case "--include": {
                        includes.add(arg);
                        continue block43;
                    }
                    case "-p": 
                    case "--pid": {
                        pid = arg;
                        continue block43;
                    }
                    case "-a": 
                    case "--args": {
                        agentArgs = arg;
                        continue block43;
                    }
                    case "-A": 
                    case "--args-provider": {
                        argsProvider = arg;
                        continue block43;
                    }
                }
                throw new IllegalArgumentException("Illegal argument: " + arg);
            }
            return new Arguments(pid, includes, excludes, agentArgs, argsProvider, help, list, continuous);
        }

        private static List<String> normalize(String[] args) {
            ArrayList<String> normalizedArgs = new ArrayList<String>(args.length);
            for (String arg : args) {
                if (arg.startsWith("-") && !arg.startsWith("--")) {
                    for (int i = 1; i < arg.length(); ++i) {
                        normalizedArgs.add("-" + arg.charAt(i));
                    }
                    continue;
                }
                normalizedArgs.add(arg);
            }
            return normalizedArgs;
        }

        void printHelp(PrintStream out) {
            out.println("SYNOPSIS");
            out.println("    java -jar apm-agent-attach.jar -p <pid> [--args <agent_arguments>]");
            out.println("    java -jar apm-agent-attach.jar [-i <include_pattern>...] [-e <exclude_pattern>...] [--continuous]");
            out.println("                                   [--args <agent_arguments> | --args-provider <args_provider_script>]");
            out.println("    java -jar apm-agent-attach.jar (--list | --help)");
            out.println();
            out.println("DESCRIPTION");
            out.println("    Attaches the Elastic APM Java agent to a JVM with a specific PID or runs continuously and attaches to all running and starting JVMs which match the filters.");
            out.println();
            out.println("OPTIONS");
            out.println("    -l, --list");
            out.println("        Lists all running JVMs. Same output as 'jps -l'.");
            out.println();
            out.println("    -p, --pid <pid>");
            out.println("        PID of the JVM to attach. If not provided, attaches to all currently running JVMs which match the --exclude and --include filters.");
            out.println();
            out.println("    -c, --continuous");
            out.println("        If provided, this program continuously runs and attaches to all running and starting JVMs which match the --exclude and --include filters.");
            out.println();
            out.println("    -e, --exclude <exclude_pattern>...");
            out.println("        A list of regular expressions of fully qualified main class names or paths to JARs of applications the java agent should not be attached to.");
            out.println("        (Matches the output of 'jps -l')");
            out.println();
            out.println("    -i, --include <include_pattern>...");
            out.println("        A list of regular expressions of fully qualified main class names or paths to JARs of applications the java agent should be attached to.");
            out.println("        (Matches the output of 'jps -l')");
            out.println();
            out.println("    -a, --args <agent_arguments>");
            out.println("        If set, the arguments are used to configure the agent on the attached JVM (agentArguments of agentmain).");
            out.println("        The syntax of the arguments is 'key1=value1;key2=value1,value2'.");
            out.println();
            out.println("    -A, --args-provider <args_provider_script>");
            out.println("        The name of a program which is called when a new JVM starts up.");
            out.println("        The program gets the pid and the main class name or path to the JAR file as an argument");
            out.println("        and returns an arg string which is used to configure the agent on the attached JVM (agentArguments of agentmain).");
            out.println("        When returning a non-zero status code from this program, the agent will not be attached to the starting JVM.");
            out.println("        The syntax of the arguments is 'key1=value1;key2=value1,value2'.");
            out.println("        Note: this option can not be used in conjunction with --pid and --args.");
        }

        String getPid() {
            return this.pid;
        }

        List<String> getIncludes() {
            return this.includes;
        }

        List<String> getExcludes() {
            return this.excludes;
        }

        String getArgs() {
            return this.args;
        }

        String getArgsProvider() {
            return this.argsProvider;
        }

        boolean isHelp() {
            return this.help;
        }

        boolean isList() {
            return this.list;
        }

        boolean isContinuous() {
            return this.continuous;
        }
    }

    static class JvmInfo {
        final String pid;
        final String packageOrPath;

        JvmInfo(String pid, String packageOrPath) {
            this.pid = pid;
            this.packageOrPath = packageOrPath;
        }

        static JvmInfo parse(String jpsLine) {
            int firstSpace = jpsLine.indexOf(32);
            return new JvmInfo(jpsLine.substring(0, firstSpace), jpsLine.substring(firstSpace + 1));
        }

        public String toString() {
            return "JvmInfo{pid='" + this.pid + '\'' + ", packageOrPath='" + this.packageOrPath + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JvmInfo jvmInfo = (JvmInfo)o;
            return this.pid.equals(jvmInfo.pid);
        }

        public int hashCode() {
            return Objects.hash(this.pid);
        }
    }
}

